/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.placeholders;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.gotev.uploadservice.data.UploadElapsedTime;
import net.gotev.uploadservice.data.UploadInfo;
import net.gotev.uploadservice.data.UploadRate;
import net.gotev.uploadservice.placeholders.Placeholder;
import net.gotev.uploadservice.placeholders.PlaceholdersProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\tH\u0016\u00a8\u0006\u0012"}, d2={"Lnet/gotev/uploadservice/placeholders/DefaultPlaceholdersProcessor;", "Lnet/gotev/uploadservice/placeholders/PlaceholdersProcessor;", "()V", "processPlaceholders", "", "message", "uploadInfo", "Lnet/gotev/uploadservice/data/UploadInfo;", "remainingFiles", "", "totalFiles", "uploadElapsedTime", "Lnet/gotev/uploadservice/data/UploadElapsedTime;", "uploadProgress", "percent", "uploadRate", "Lnet/gotev/uploadservice/data/UploadRate;", "uploadedFiles", "uploadservice_release"})
public class DefaultPlaceholdersProcessor
implements PlaceholdersProcessor {
    @NotNull
    public String uploadElapsedTime(@NotNull UploadElapsedTime uploadElapsedTime) {
        Intrinsics.checkNotNullParameter((Object)uploadElapsedTime, (String)"uploadElapsedTime");
        return uploadElapsedTime.getMinutes() == 0 ? uploadElapsedTime.getSeconds() + " sec" : uploadElapsedTime.getMinutes() + " min " + uploadElapsedTime.getSeconds() + " sec";
    }

    @NotNull
    public String uploadRate(@NotNull UploadRate uploadRate) {
        Intrinsics.checkNotNullParameter((Object)uploadRate, (String)"uploadRate");
        String suffix = switch (WhenMappings.$EnumSwitchMapping$0[uploadRate.getUnit().ordinal()]) {
            case 1 -> "b/s";
            case 2 -> "kb/s";
            case 3 -> "Mb/s";
            default -> throw new NoWhenBranchMatchedException();
        };
        return uploadRate.getValue() + " " + suffix;
    }

    @NotNull
    public String uploadProgress(int percent) {
        return percent + " %";
    }

    @NotNull
    public String uploadedFiles(int uploadedFiles) {
        return String.valueOf(uploadedFiles);
    }

    @NotNull
    public String remainingFiles(int remainingFiles) {
        return String.valueOf(remainingFiles);
    }

    @NotNull
    public String totalFiles(int totalFiles) {
        return String.valueOf(totalFiles);
    }

    @Override
    @NotNull
    public String processPlaceholders(@Nullable String message, @NotNull UploadInfo uploadInfo) {
        Intrinsics.checkNotNullParameter((Object)uploadInfo, (String)"uploadInfo");
        String string = message;
        if (string == null) {
            return "";
        }
        String safeMessage = string;
        int uploadedFiles = uploadInfo.getSuccessfullyUploadedFiles();
        int totalFiles = uploadInfo.getFiles().size();
        int remainingFiles = totalFiles - uploadedFiles;
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)safeMessage, (String)Placeholder.ElapsedTime.getValue(), (String)this.uploadElapsedTime(uploadInfo.getElapsedTime()), (boolean)false, (int)4, null), (String)Placeholder.UploadRate.getValue(), (String)this.uploadRate(uploadInfo.getUploadRate()), (boolean)false, (int)4, null), (String)Placeholder.Progress.getValue(), (String)this.uploadProgress(uploadInfo.getProgressPercent()), (boolean)false, (int)4, null), (String)Placeholder.UploadedFiles.getValue(), (String)this.uploadedFiles(uploadedFiles), (boolean)false, (int)4, null), (String)Placeholder.RemainingFiles.getValue(), (String)this.remainingFiles(remainingFiles), (boolean)false, (int)4, null), (String)Placeholder.TotalFiles.getValue(), (String)this.totalFiles(totalFiles), (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UploadRate.UploadRateUnit.values().length];
            try {
                nArray[UploadRate.UploadRateUnit.BitPerSecond.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UploadRate.UploadRateUnit.KilobitPerSecond.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UploadRate.UploadRateUnit.MegabitPerSecond.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

