/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.protocols.multipart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.gotev.uploadservice.HttpUploadTask;
import net.gotev.uploadservice.data.NameValue;
import net.gotev.uploadservice.data.UploadFile;
import net.gotev.uploadservice.extensions.CollectionsExtensionsKt;
import net.gotev.uploadservice.extensions.StringExtensionsKt;
import net.gotev.uploadservice.network.BodyWriter;
import net.gotev.uploadservice.protocols.multipart.UploadFileExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\f\u0010\u001f\u001a\u00020\u001b*\u00020\u001dH\u0002J\f\u0010 \u001a\u00020\u001b*\u00020\u001dH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00020\n*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0011\u001a\u00020\n*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\u0004*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Lnet/gotev/uploadservice/protocols/multipart/MultipartUploadTask;", "Lnet/gotev/uploadservice/HttpUploadTask;", "()V", "bodyLength", "", "getBodyLength", "()J", "boundary", "", "boundaryBytes", "", "filesLength", "getFilesLength", "newLineBytes", "requestParametersLength", "getRequestParametersLength", "trailerBytes", "multipartHeader", "Lnet/gotev/uploadservice/data/NameValue;", "getMultipartHeader", "(Lnet/gotev/uploadservice/data/NameValue;)[B", "Lnet/gotev/uploadservice/data/UploadFile;", "(Lnet/gotev/uploadservice/data/UploadFile;)[B", "totalMultipartBytes", "getTotalMultipartBytes", "(Lnet/gotev/uploadservice/data/UploadFile;)J", "onWriteRequestBody", "", "bodyWriter", "Lnet/gotev/uploadservice/network/BodyWriter;", "performInitialization", "writeFiles", "writeRequestParameters", "Companion", "uploadservice_release"})
@SourceDebugExtension(value={"SMAP\nMultipartUploadTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartUploadTask.kt\nnet/gotev/uploadservice/protocols/multipart/MultipartUploadTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1855#2,2:87\n1549#2:89\n1620#2,3:90\n1549#2:93\n1620#2,3:94\n*S KotlinDebug\n*F\n+ 1 MultipartUploadTask.kt\nnet/gotev/uploadservice/protocols/multipart/MultipartUploadTask\n*L\n42#1:87,2\n58#1:89\n58#1:90,3\n61#1:93\n61#1:94,3\n*E\n"})
public final class MultipartUploadTask
extends HttpUploadTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String boundary = "-------UploadService4.9.2-" + System.nanoTime();
    @NotNull
    private final byte[] boundaryBytes = StringExtensionsKt.getAsciiBytes("--" + this.boundary + "\r\n");
    @NotNull
    private final byte[] trailerBytes = StringExtensionsKt.getAsciiBytes("--" + this.boundary + "--\r\n");
    @NotNull
    private final byte[] newLineBytes = StringExtensionsKt.getUtf8Bytes("\r\n");
    @NotNull
    private static final String BOUNDARY_SIGNATURE = "-------UploadService4.9.2-";
    @NotNull
    private static final String NEW_LINE = "\r\n";
    @NotNull
    private static final String TWO_HYPHENS = "--";

    private final byte[] getMultipartHeader(NameValue $this$multipartHeader) {
        return ArraysKt.plus((byte[])this.boundaryBytes, (byte[])StringExtensionsKt.getUtf8Bytes("Content-Disposition: form-data; name=\"" + $this$multipartHeader.getName() + "\"\r\n\r\n" + $this$multipartHeader.getValue() + NEW_LINE));
    }

    private final byte[] getMultipartHeader(UploadFile $this$multipartHeader) {
        return ArraysKt.plus((byte[])this.boundaryBytes, (byte[])StringExtensionsKt.getUtf8Bytes("Content-Disposition: form-data; name=\"" + UploadFileExtensionsKt.getParameterName($this$multipartHeader) + "\"; filename=\"" + UploadFileExtensionsKt.getRemoteFileName($this$multipartHeader) + "\"\r\nContent-Type: " + UploadFileExtensionsKt.getContentType($this$multipartHeader) + "\r\n\r\n"));
    }

    private final long getTotalMultipartBytes(UploadFile $this$totalMultipartBytes) {
        return (long)this.getMultipartHeader($this$totalMultipartBytes).length + $this$totalMultipartBytes.getHandler().size(this.getContext()) + (long)this.newLineBytes.length;
    }

    private final void writeRequestParameters(BodyWriter $this$writeRequestParameters) {
        Iterable $this$forEach$iv = this.getHttpParams().getRequestParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NameValue it = (NameValue)element$iv;
            boolean bl = false;
            $this$writeRequestParameters.write(this.getMultipartHeader(it));
        }
    }

    private final void writeFiles(BodyWriter $this$writeFiles) {
        for (UploadFile file2 : this.getParams().getFiles()) {
            if (!this.getShouldContinue()) break;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            $this$writeFiles.write(this.getMultipartHeader(file2));
            $this$writeFiles.writeStream(file2.getHandler().stream(this.getContext()));
            $this$writeFiles.write(this.newLineBytes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long getRequestParametersLength() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getHttpParams().getRequestParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NameValue nameValue = (NameValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Long.valueOf(this.getMultipartHeader((NameValue)it).length));
        }
        return CollectionsKt.sumOfLong((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final long getFilesLength() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getParams().getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UploadFile uploadFile = (UploadFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getTotalMultipartBytes((UploadFile)it));
        }
        return CollectionsKt.sumOfLong((Iterable)((List)destination$iv$iv));
    }

    @Override
    public long getBodyLength() {
        return this.getRequestParametersLength() + this.getFilesLength() + (long)this.trailerBytes.length;
    }

    @Override
    public void performInitialization() {
        ArrayList<NameValue> arrayList;
        ArrayList<NameValue> $this$performInitialization_u24lambda_u243 = arrayList = this.getHttpParams().getRequestHeaders();
        boolean bl = false;
        CollectionsExtensionsKt.addHeader($this$performInitialization_u24lambda_u243, "Content-Type", "multipart/form-data; boundary=" + this.boundary);
        CollectionsExtensionsKt.addHeader($this$performInitialization_u24lambda_u243, "Connection", this.getParams().getFiles().size() <= 1 ? "close" : "Keep-Alive");
    }

    @Override
    public void onWriteRequestBody(@NotNull BodyWriter bodyWriter) {
        BodyWriter bodyWriter2;
        Intrinsics.checkNotNullParameter((Object)bodyWriter, (String)"bodyWriter");
        this.resetUploadedBytes();
        this.setAllFilesHaveBeenSuccessfullyUploaded(false);
        BodyWriter $this$onWriteRequestBody_u24lambda_u244 = bodyWriter2 = bodyWriter;
        boolean bl = false;
        this.writeRequestParameters($this$onWriteRequestBody_u24lambda_u244);
        this.writeFiles($this$onWriteRequestBody_u24lambda_u244);
        $this$onWriteRequestBody_u24lambda_u244.write(this.trailerBytes);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/gotev/uploadservice/protocols/multipart/MultipartUploadTask$Companion;", "", "()V", "BOUNDARY_SIGNATURE", "", "NEW_LINE", "TWO_HYPHENS", "uploadservice_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

