/*
 * Decompiled with CFR 0.152.
 */
package net.gpedro.integrations.slack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.gpedro.integrations.slack.SlackAction;
import net.gpedro.integrations.slack.SlackField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlackAttachment {
    private static final String HEX_REGEX = "^([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
    private static final String FALLBACK = "fallback";
    private static final String CALLBACK_ID = "callback_id";
    private static final String TEXT = "text";
    private static final String PRETEXT = "pretext";
    private static final String COLOR = "color";
    private static final String FIELDS = "fields";
    private static final String AUTHOR_NAME = "author_name";
    private static final String AUTHOR_LINK = "author_link";
    private static final String AUTHOR_ICON = "author_icon";
    private static final String TITLE = "title";
    private static final String TITLE_LINK = "title_link";
    private static final String IMAGE_URL = "image_url";
    private static final String THUMB_URL = "thumb_url";
    private static final String MRKDWN_IN = "mrkdwn_in";
    private static final String ACTIONS = "actions";
    private String fallback;
    private String callbackId;
    private String text;
    private String pretext;
    private String color;
    private String authorName;
    private String authorLink;
    private String authorIcon;
    private String title;
    private String titleLink;
    private String imageUrl;
    private String thumbUrl;
    private Set<String> markdownAttributes = new HashSet<String>();
    private List<SlackField> fields = new ArrayList<SlackField>();
    private List<SlackAction> actions = new ArrayList<SlackAction>();

    public SlackAttachment() {
    }

    public SlackAttachment(String fallback) {
        this.fallback = fallback;
    }

    public SlackAttachment addFields(SlackField field) {
        this.fields.add(field);
        return this;
    }

    public SlackAttachment addAction(SlackAction action) {
        this.actions.add(action);
        return this;
    }

    public SlackAttachment addMarkdownAttribute(String attr) {
        this.markdownAttributes.add(attr);
        return this;
    }

    private boolean isHex(String pair) {
        return pair.matches(HEX_REGEX);
    }

    private JsonArray prepareFields() {
        JsonArray data = new JsonArray();
        for (SlackField field : this.fields) {
            data.add((JsonElement)field.toJson());
        }
        return data;
    }

    private JsonArray prepareActions() {
        JsonArray data = new JsonArray();
        for (SlackAction action : this.actions) {
            data.add((JsonElement)action.toJson());
        }
        return data;
    }

    public SlackAttachment removeAction(int index) {
        this.actions.remove(index);
        return this;
    }

    public SlackAttachment removeFields(int index) {
        this.fields.remove(index);
        return this;
    }

    private JsonArray prepareMarkdownAttributes() {
        JsonArray data = new JsonArray();
        for (String attr : this.markdownAttributes) {
            data.add((JsonElement)new JsonPrimitive(attr));
        }
        return data;
    }

    public SlackAttachment removeMarkdownAttribute(String attr) {
        this.markdownAttributes.remove(attr);
        return this;
    }

    public SlackAttachment setColor(String color) {
        if (color != null) {
            if (color.charAt(0) == '#') {
                if (!this.isHex(color.substring(1))) {
                    throw new IllegalArgumentException("Invalid Hex Color @ SlackAttachment");
                }
            } else if (!color.matches("^(good|warning|danger)$")) {
                throw new IllegalArgumentException("Invalid PreDefined Color @ SlackAttachment");
            }
        }
        this.color = color;
        return this;
    }

    public SlackAttachment setFallback(String fallback) {
        this.fallback = fallback;
        return this;
    }

    public SlackAttachment setCallbackId(String callbackId) {
        this.callbackId = callbackId;
        return this;
    }

    public SlackAttachment setFields(List<SlackField> fields) {
        this.fields = fields;
        return this;
    }

    public SlackAttachment setPretext(String pretext) {
        this.pretext = pretext;
        return this;
    }

    public SlackAttachment setText(String text) {
        this.text = text;
        return this;
    }

    public SlackAttachment setAuthorName(String authorName) {
        this.authorName = authorName;
        return this;
    }

    public SlackAttachment setAuthorLink(String authorLink) {
        this.authorLink = authorLink;
        return this;
    }

    public SlackAttachment setAuthorIcon(String authorIcon) {
        this.authorIcon = authorIcon;
        return this;
    }

    public SlackAttachment setTitle(String title) {
        this.title = title;
        return this;
    }

    public SlackAttachment setTitleLink(String titleLink) {
        this.titleLink = titleLink;
        return this;
    }

    public SlackAttachment setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    public SlackAttachment setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
        return this;
    }

    public JsonObject toJson() {
        JsonObject data = new JsonObject();
        if (this.fallback == null) {
            throw new IllegalArgumentException("Missing Fallback @ SlackAttachment");
        }
        data.addProperty(FALLBACK, this.fallback);
        if (this.text != null) {
            data.addProperty(TEXT, this.text);
        }
        if (this.pretext != null) {
            data.addProperty(PRETEXT, this.pretext);
        }
        if (this.color != null) {
            data.addProperty(COLOR, this.color);
        }
        if (this.authorName != null) {
            data.addProperty(AUTHOR_NAME, this.authorName);
        }
        if (this.authorLink != null) {
            data.addProperty(AUTHOR_LINK, this.authorLink);
        }
        if (this.authorIcon != null) {
            data.addProperty(AUTHOR_ICON, this.authorIcon);
        }
        if (this.title != null) {
            data.addProperty(TITLE, this.title);
        }
        if (this.titleLink != null) {
            data.addProperty(TITLE_LINK, this.titleLink);
        }
        if (this.imageUrl != null) {
            data.addProperty(IMAGE_URL, this.imageUrl);
        }
        if (this.thumbUrl != null) {
            data.addProperty(THUMB_URL, this.thumbUrl);
        }
        if (this.markdownAttributes != null) {
            data.add(MRKDWN_IN, (JsonElement)this.prepareMarkdownAttributes());
        }
        if (this.fields != null && this.fields.size() > 0) {
            data.add(FIELDS, (JsonElement)this.prepareFields());
        }
        if (this.actions != null && this.actions.size() > 0) {
            data.add(ACTIONS, (JsonElement)this.prepareActions());
            if (this.callbackId == null) {
                throw new IllegalArgumentException("Missing Callback ID @ SlackAttachment");
            }
            data.addProperty(CALLBACK_ID, this.callbackId);
        }
        return data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlackAttachment that = (SlackAttachment)o;
        if (this.fallback != null ? !this.fallback.equals(that.fallback) : that.fallback != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        if (this.pretext != null ? !this.pretext.equals(that.pretext) : that.pretext != null) {
            return false;
        }
        if (this.color != null ? !this.color.equals(that.color) : that.color != null) {
            return false;
        }
        if (this.authorName != null ? !this.authorName.equals(that.authorName) : that.authorName != null) {
            return false;
        }
        if (this.authorLink != null ? !this.authorLink.equals(that.authorLink) : that.authorLink != null) {
            return false;
        }
        if (this.authorIcon != null ? !this.authorIcon.equals(that.authorIcon) : that.authorIcon != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.titleLink != null ? !this.titleLink.equals(that.titleLink) : that.titleLink != null) {
            return false;
        }
        if (this.imageUrl != null ? !this.imageUrl.equals(that.imageUrl) : that.imageUrl != null) {
            return false;
        }
        if (this.thumbUrl != null ? !this.thumbUrl.equals(that.thumbUrl) : that.thumbUrl != null) {
            return false;
        }
        if (this.markdownAttributes != null ? !this.markdownAttributes.equals(that.markdownAttributes) : that.markdownAttributes != null) {
            return false;
        }
        return !(this.fields == null ? that.fields != null : !this.fields.equals(that.fields));
    }

    public int hashCode() {
        int result = this.fallback != null ? this.fallback.hashCode() : 0;
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.pretext != null ? this.pretext.hashCode() : 0);
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + (this.authorName != null ? this.authorName.hashCode() : 0);
        result = 31 * result + (this.authorLink != null ? this.authorLink.hashCode() : 0);
        result = 31 * result + (this.authorIcon != null ? this.authorIcon.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.titleLink != null ? this.titleLink.hashCode() : 0);
        result = 31 * result + (this.imageUrl != null ? this.imageUrl.hashCode() : 0);
        result = 31 * result + (this.thumbUrl != null ? this.thumbUrl.hashCode() : 0);
        result = 31 * result + (this.markdownAttributes != null ? this.markdownAttributes.hashCode() : 0);
        result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SlackAttachment{fallback='" + this.fallback + '\'' + ", text='" + this.text + '\'' + ", pretext='" + this.pretext + '\'' + ", color='" + this.color + '\'' + ", authorName='" + this.authorName + '\'' + ", authorLink='" + this.authorLink + '\'' + ", authorIcon='" + this.authorIcon + '\'' + ", title='" + this.title + '\'' + ", titleLink='" + this.titleLink + '\'' + ", imageUrl='" + this.imageUrl + '\'' + ", thumbUrl='" + this.thumbUrl + '\'' + ", markdownAttributes=" + this.markdownAttributes + ", fields=" + this.fields + '}';
    }
}

