/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque;

import java.io.Serializable;

public class Config
implements Serializable {
    private static final long serialVersionUID = -6638770587683679373L;
    private final String host;
    private final int port;
    private final int timeout;
    private final String password;
    private final String namespace;
    private final int database;

    public Config(String host, int port, int timeout, String password, String namespace, int database) {
        if (host == null || "".equals(host)) {
            throw new IllegalArgumentException("host must not be null or empty: " + host);
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("post must be a valid port in the range 1-65535: " + port);
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must not be negative: " + timeout);
        }
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException("namespace must not be null or empty: " + namespace);
        }
        if (database < 0) {
            throw new IllegalArgumentException("database must not be negative: " + database);
        }
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.password = password;
        this.namespace = namespace;
        this.database = database;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getDatabase() {
        return this.database;
    }

    public String getURI() {
        return "redis://" + this.host + ":" + this.port + "/" + this.database;
    }

    public String toString() {
        return "<" + this.getURI() + " namespace=" + this.namespace + " timeout=" + this.timeout + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.database;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + this.timeout;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Config other = (Config)obj;
        if (this.database != other.database) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.timeout != other.timeout) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
    }
}

