/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque;

import java.io.Serializable;
import net.greghaines.jesque.Config;

public class ConfigBuilder
implements Serializable {
    private static final long serialVersionUID = 730947307298353317L;
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 6379;
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final String DEFAULT_PASSWORD = null;
    public static final String DEFAULT_NAMESPACE = "resque";
    public static final int DEFAULT_DATABASE = 0;
    private String host = "localhost";
    private int port = 6379;
    private int timeout = 5000;
    private String password = DEFAULT_PASSWORD;
    private String namespace = "resque";
    private int database = 0;

    public static Config getDefaultConfig() {
        return new ConfigBuilder().build();
    }

    public ConfigBuilder() {
    }

    public ConfigBuilder(Config startingPoint) {
        if (startingPoint == null) {
            throw new IllegalArgumentException("startingPoint must not be null");
        }
        this.host = startingPoint.getHost();
        this.port = startingPoint.getPort();
        this.timeout = startingPoint.getTimeout();
        this.namespace = startingPoint.getNamespace();
        this.database = startingPoint.getDatabase();
    }

    public ConfigBuilder withHost(String host) {
        if (host == null || "".equals(host)) {
            throw new IllegalArgumentException("host must not be null or empty: " + host);
        }
        this.host = host;
        return this;
    }

    public ConfigBuilder withPort(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("post must be a valid port in the range 1-65535: " + port);
        }
        this.port = port;
        return this;
    }

    public ConfigBuilder withTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must not be negative: " + timeout);
        }
        this.timeout = timeout;
        return this;
    }

    public ConfigBuilder withPassword(String password) {
        this.password = password;
        return this;
    }

    public ConfigBuilder withNamespace(String namespace) {
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException("namespace must not be null or empty: " + namespace);
        }
        this.namespace = namespace;
        return this;
    }

    public ConfigBuilder withDatabase(int database) {
        if (database < 0) {
            throw new IllegalArgumentException("database must not be negative: " + database);
        }
        this.database = database;
        return this;
    }

    public Config build() {
        return new Config(this.host, this.port, this.timeout, this.password, this.namespace, this.database);
    }
}

