/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class Job
implements Serializable {
    private static final long serialVersionUID = -1523425239512691383L;
    private String className;
    private Object[] args;

    public Job() {
    }

    public Job(Job origJob) {
        if (origJob == null) {
            throw new IllegalArgumentException("origJob must not be null");
        }
        this.className = origJob.className;
        this.args = origJob.args == null ? null : (Object[])origJob.args.clone();
    }

    public Job(String className, List<?> args) {
        this(className, args.toArray());
    }

    public Job(String className, Object ... args) {
        if (className == null || "".equals(className)) {
            throw new IllegalArgumentException("className must not be null or empty: " + className);
        }
        this.className = className;
        this.args = args;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public boolean isValid() {
        return this.args != null && this.className != null && !"".equals(this.className);
    }

    public String toString() {
        return "<Job className=" + this.className + " args=" + Arrays.toString(this.args) + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Job other = (Job)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return Arrays.equals(this.args, other.args);
    }
}

