/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.client;

import net.greghaines.jesque.Config;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.client.Client;
import net.greghaines.jesque.json.ObjectMapperFactory;
import net.greghaines.jesque.utils.JesqueUtils;
import redis.clients.jedis.Jedis;

public abstract class AbstractClient
implements Client {
    private final String namespace;

    protected AbstractClient(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        this.namespace = config.getNamespace();
    }

    protected String getNamespace() {
        return this.namespace;
    }

    protected String key(String ... parts) {
        return JesqueUtils.createKey(this.namespace, parts);
    }

    @Override
    public void enqueue(String queue, Job job) {
        AbstractClient.validateArguments(queue, job);
        try {
            this.doEnqueue(queue, ObjectMapperFactory.get().writeValueAsString((Object)job));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void priorityEnqueue(String queue, Job job) {
        AbstractClient.validateArguments(queue, job);
        try {
            this.doPriorityEnqueue(queue, ObjectMapperFactory.get().writeValueAsString((Object)job));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean acquireLock(String lockName, String lockHolder, Integer timeout) {
        if (lockName == null || "".equals(lockName)) {
            throw new IllegalArgumentException("lockName must not be null or empty: " + lockName);
        }
        if (lockHolder == null || "".equals(lockHolder)) {
            throw new IllegalArgumentException("lockHolder must not be null or empty: " + lockHolder);
        }
        if (timeout == null) {
            throw new IllegalArgumentException("job must not be null");
        }
        if (timeout < 1) {
            throw new IllegalArgumentException("timeout must be a positive number");
        }
        try {
            return this.doAcquireLock(lockName, lockHolder, timeout);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void doEnqueue(String var1, String var2) throws Exception;

    protected abstract void doPriorityEnqueue(String var1, String var2) throws Exception;

    protected abstract boolean doAcquireLock(String var1, String var2, Integer var3) throws Exception;

    public static void doEnqueue(Jedis jedis, String namespace, String queue, String jobJson) {
        jedis.sadd(JesqueUtils.createKey(namespace, "queues"), new String[]{queue});
        jedis.rpush(JesqueUtils.createKey(namespace, "queue", queue), new String[]{jobJson});
    }

    public static void doPriorityEnqueue(Jedis jedis, String namespace, String queue, String jobJson) {
        jedis.sadd(JesqueUtils.createKey(namespace, "queues"), new String[]{queue});
        jedis.lpush(JesqueUtils.createKey(namespace, "queue", queue), new String[]{jobJson});
    }

    public static boolean doAcquireLock(Jedis jedis, String namespace, String lockName, String lockHolder, Integer timeout) {
        String key = JesqueUtils.createKey(namespace, lockName);
        String existingLockHolder = jedis.get(key);
        if (existingLockHolder != null && existingLockHolder.equals(lockHolder) && jedis.expire(key, timeout.intValue()) == 1L && (existingLockHolder = jedis.get(key)) != null && existingLockHolder.equals(lockHolder)) {
            return true;
        }
        if (jedis.exists(key).booleanValue() && jedis.ttl(key) < 0L) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (jedis.ttl(key) < 0L) {
                existingLockHolder = jedis.get(key);
                if (existingLockHolder != null && existingLockHolder.equals(lockHolder)) {
                    if (jedis.expire(key, timeout.intValue()) == 1L && (existingLockHolder = jedis.get(key)) != null && existingLockHolder.equals(lockHolder)) {
                        return true;
                    }
                } else {
                    jedis.del(new String[]{key});
                }
            } else {
                return false;
            }
        }
        if (jedis.setnx(key, lockHolder) == 1L) {
            if (jedis.expire(key, timeout.intValue()) == 1L) {
                existingLockHolder = jedis.get(key);
                if (existingLockHolder != null && existingLockHolder.equals(lockHolder)) {
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    private static void validateArguments(String queue, Job job) {
        if (queue == null || "".equals(queue)) {
            throw new IllegalArgumentException("queue must not be null or empty: " + queue);
        }
        if (job == null) {
            throw new IllegalArgumentException("job must not be null");
        }
        if (!job.isValid()) {
            throw new IllegalStateException("job is not valid: " + job);
        }
    }
}

