/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.client;

import net.greghaines.jesque.Config;
import net.greghaines.jesque.client.AbstractClient;
import net.greghaines.jesque.utils.PoolUtils;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class ClientPoolImpl
extends AbstractClient {
    private final Pool<Jedis> jedisPool;

    public ClientPoolImpl(Config config, Pool<Jedis> jedisPool) {
        super(config);
        if (jedisPool == null) {
            throw new IllegalArgumentException("jedisPool must not be null");
        }
        this.jedisPool = jedisPool;
    }

    @Override
    protected void doEnqueue(final String queue, final String jobJson) throws Exception {
        PoolUtils.doWorkInPool(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

            @Override
            public Void doWork(Jedis jedis) {
                AbstractClient.doEnqueue(jedis, ClientPoolImpl.this.getNamespace(), queue, jobJson);
                return null;
            }
        });
    }

    @Override
    protected void doPriorityEnqueue(final String queue, final String jobJson) throws Exception {
        PoolUtils.doWorkInPool(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

            @Override
            public Void doWork(Jedis jedis) {
                AbstractClient.doPriorityEnqueue(jedis, ClientPoolImpl.this.getNamespace(), queue, jobJson);
                return null;
            }
        });
    }

    @Override
    protected boolean doAcquireLock(final String lockName, final String lockHolder, final Integer timeout) throws Exception {
        return PoolUtils.doWorkInPool(this.jedisPool, new PoolUtils.PoolWork<Jedis, Boolean>(){

            @Override
            public Boolean doWork(Jedis jedis) {
                return AbstractClient.doAcquireLock(jedis, ClientPoolImpl.this.getNamespace(), lockName, lockHolder, timeout);
            }
        });
    }

    @Override
    public void end() {
    }
}

