/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.JobFailure;
import net.greghaines.jesque.utils.JesqueUtils;

public class JobFailureJsonDeserializer
extends JsonDeserializer<JobFailure> {
    private static final TypeReference<List<String>> stringListTypeRef = new TypeReference<List<String>>(){};

    public JobFailure deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JobFailure jobFailure = new JobFailure();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            jp.nextToken();
            if ("worker".equals(jp.getText())) {
                jp.nextToken();
                jobFailure.setWorker((String)jp.readValueAs(String.class));
                continue;
            }
            if ("queue".equals(jp.getText())) {
                jp.nextToken();
                jobFailure.setQueue((String)jp.readValueAs(String.class));
                continue;
            }
            if ("payload".equals(jp.getText())) {
                jp.nextToken();
                jobFailure.setPayload((Job)jp.readValueAs(Job.class));
                continue;
            }
            if ("exception".equals(jp.getText())) {
                jp.nextToken();
                jobFailure.setExceptionString((String)jp.readValueAs(String.class));
                continue;
            }
            if ("error".equals(jp.getText())) {
                jp.nextToken();
                jobFailure.setError((String)jp.readValueAs(String.class));
                continue;
            }
            if ("backtrace".equals(jp.getText())) {
                jp.nextToken();
                jobFailure.setBacktrace((List)jp.readValueAs(stringListTypeRef));
                continue;
            }
            if ("failed_at".equals(jp.getText())) {
                jp.nextToken();
                jobFailure.setFailedAt((Date)jp.readValueAs(Date.class));
                continue;
            }
            if ("retried_at".equals(jp.getText())) {
                jp.nextToken();
                jobFailure.setRetriedAt((Date)jp.readValueAs(Date.class));
                continue;
            }
            if (jp.getCurrentToken() == JsonToken.END_OBJECT) continue;
            throw new JsonMappingException("Unexpected field for JobFailure: " + jp.getText(), jp.getCurrentLocation());
        }
        if (jobFailure.getExceptionString() != null) {
            try {
                jobFailure.setException(JesqueUtils.recreateThrowable(jobFailure.getExceptionString(), jobFailure.getError(), jobFailure.getBacktrace()));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return jobFailure;
    }
}

