/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.json;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.JobFailure;
import net.greghaines.jesque.WorkerStatus;
import net.greghaines.jesque.json.JobFailureJsonDeserializer;
import net.greghaines.jesque.json.JobFailureJsonSerializer;
import net.greghaines.jesque.json.JobJsonDeserializer;
import net.greghaines.jesque.json.JobJsonSerializer;
import net.greghaines.jesque.json.WorkerStatusJsonDeserializer;
import net.greghaines.jesque.json.WorkerStatusJsonSerializer;
import net.greghaines.jesque.utils.VersionUtils;

public final class ObjectMapperFactory {
    private static final ObjectMapper mapper = new ObjectMapper();

    private static Version createJacksonVersion() {
        Object[] versionParts = VersionUtils.getVersionParts();
        return "DEVELOPMENT".equals(versionParts[3]) || "ERROR".equals(versionParts[3]) ? Version.unknownVersion() : new Version(((Integer)versionParts[0]).intValue(), ((Integer)versionParts[1]).intValue(), ((Integer)versionParts[2]).intValue(), (String)versionParts[3], "net.greghaines", "jesque");
    }

    public static ObjectMapper get() {
        return mapper;
    }

    private ObjectMapperFactory() {
    }

    static {
        mapper.registerModule((Module)new SimpleModule("net.greghaines.jesque", ObjectMapperFactory.createJacksonVersion()).addSerializer(Job.class, (JsonSerializer)new JobJsonSerializer()).addDeserializer(Job.class, (JsonDeserializer)new JobJsonDeserializer()).addSerializer(JobFailure.class, (JsonSerializer)new JobFailureJsonSerializer()).addDeserializer(JobFailure.class, (JsonDeserializer)new JobFailureJsonDeserializer()).addSerializer(WorkerStatus.class, (JsonSerializer)new WorkerStatusJsonSerializer()).addDeserializer(WorkerStatus.class, (JsonDeserializer)new WorkerStatusJsonDeserializer()));
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }
}

