/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.meta.dao.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import net.greghaines.jesque.Config;
import net.greghaines.jesque.meta.KeyInfo;
import net.greghaines.jesque.meta.KeyType;
import net.greghaines.jesque.meta.dao.KeysDAO;
import net.greghaines.jesque.utils.PoolUtils;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class KeysDAORedisImpl
implements KeysDAO {
    private static final Pattern newLinePattern = Pattern.compile("\r\n");
    private static final Pattern colonPattern = Pattern.compile(":");
    private final Config config;
    private final Pool<Jedis> jedisPool;

    public KeysDAORedisImpl(Config config, Pool<Jedis> jedisPool) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (jedisPool == null) {
            throw new IllegalArgumentException("jedisPool must not be null");
        }
        this.config = config;
        this.jedisPool = jedisPool;
    }

    @Override
    public KeyInfo getKeyInfo(String key) {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new KeyDAOPoolWork(key));
    }

    @Override
    public KeyInfo getKeyInfo(String key, int offset, int count) {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new KeyDAOPoolWork(key, offset, count));
    }

    @Override
    public List<KeyInfo> getKeyInfos() {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, List<KeyInfo>>(){

            @Override
            public List<KeyInfo> doWork(Jedis jedis) throws Exception {
                Set keys = jedis.keys(KeysDAORedisImpl.this.config.getNamespace() + ":" + "*");
                ArrayList<KeyInfo> keyInfos = new ArrayList<KeyInfo>(keys.size());
                for (String key : keys) {
                    keyInfos.add(new KeyDAOPoolWork(key).doWork(jedis));
                }
                Collections.sort(keyInfos);
                return keyInfos;
            }
        });
    }

    @Override
    public Map<String, String> getRedisInfo() {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Map<String, String>>(){

            @Override
            public Map<String, String> doWork(Jedis jedis) throws Exception {
                String[] keyValueStrs;
                TreeMap<String, String> infoMap = new TreeMap<String, String>();
                String infoStr = jedis.info();
                for (String keyValueStr : keyValueStrs = newLinePattern.split(infoStr)) {
                    String[] keyAndValue = colonPattern.split(keyValueStr, 2);
                    if (keyAndValue.length == 1) {
                        infoMap.put(keyAndValue[0], null);
                        continue;
                    }
                    infoMap.put(keyAndValue[0], keyAndValue[1]);
                }
                return new LinkedHashMap<String, String>(infoMap);
            }
        });
    }

    private static final class KeyDAOPoolWork
    implements PoolUtils.PoolWork<Jedis, KeyInfo> {
        private final String key;
        private final int offset;
        private final int count;
        private final boolean doArrayValue;

        private KeyDAOPoolWork(String key) {
            this.key = key;
            this.offset = -1;
            this.count = -1;
            this.doArrayValue = false;
        }

        private KeyDAOPoolWork(String key, int offset, int count) {
            this.key = key;
            this.offset = offset;
            this.count = count;
            this.doArrayValue = true;
        }

        @Override
        public KeyInfo doWork(Jedis jedis) throws Exception {
            KeyInfo keyInfo;
            KeyType keyType = KeyType.getKeyTypeByValue(jedis.type(this.key));
            switch (keyType) {
                case HASH: {
                    keyInfo = new KeyInfo(this.key, keyType);
                    keyInfo.setSize(jedis.hlen(this.key));
                    if (!this.doArrayValue) break;
                    ArrayList allFields = new ArrayList(jedis.hkeys(this.key));
                    if (this.offset >= allFields.size()) {
                        keyInfo.setArrayValue(new ArrayList<String>(1));
                        break;
                    }
                    int toIndex = this.offset + this.count > allFields.size() ? allFields.size() : this.offset + this.count;
                    List subFields = allFields.subList(this.offset, toIndex);
                    List values = jedis.hmget(this.key, subFields.toArray(new String[subFields.size()]));
                    ArrayList<String> arrayValue = new ArrayList<String>(subFields.size());
                    for (int i = 0; i < subFields.size(); ++i) {
                        arrayValue.add("{" + (String)subFields.get(i) + "=" + (String)values.get(i) + "}");
                    }
                    keyInfo.setArrayValue(arrayValue);
                    break;
                }
                case LIST: {
                    keyInfo = new KeyInfo(this.key, keyType);
                    keyInfo.setSize(jedis.llen(this.key));
                    if (!this.doArrayValue) break;
                    keyInfo.setArrayValue(jedis.lrange(this.key, (long)this.offset, (long)(this.offset + this.count)));
                    break;
                }
                case SET: {
                    keyInfo = new KeyInfo(this.key, keyType);
                    keyInfo.setSize(jedis.scard(this.key));
                    if (!this.doArrayValue) break;
                    ArrayList allMembers = new ArrayList(jedis.smembers(this.key));
                    if (this.offset >= allMembers.size()) {
                        keyInfo.setArrayValue(new ArrayList<String>(1));
                        break;
                    }
                    int toIndex = this.offset + this.count > allMembers.size() ? allMembers.size() : this.offset + this.count;
                    keyInfo.setArrayValue(new ArrayList<String>(allMembers.subList(this.offset, toIndex)));
                    break;
                }
                case STRING: {
                    keyInfo = new KeyInfo(this.key, keyType);
                    keyInfo.setSize(jedis.strlen(this.key));
                    if (!this.doArrayValue) break;
                    ArrayList<String> arrayValue = new ArrayList<String>(1);
                    arrayValue.add(jedis.get(this.key));
                    keyInfo.setArrayValue(arrayValue);
                    break;
                }
                case ZSET: {
                    keyInfo = new KeyInfo(this.key, keyType);
                    keyInfo.setSize(jedis.zcard(this.key));
                    if (!this.doArrayValue) break;
                    keyInfo.setArrayValue(new ArrayList<String>(jedis.zrange(this.key, (long)this.offset, (long)(this.offset + this.count))));
                    break;
                }
                default: {
                    keyInfo = null;
                }
            }
            return keyInfo;
        }
    }
}

