/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.greghaines.jesque.utils.ConcurrentSet;

public class ConcurrentHashSet<E>
implements ConcurrentSet<E> {
    private final ConcurrentMap<E, Nothing> delegate;

    public ConcurrentHashSet() {
        this.delegate = new ConcurrentHashMap<E, Nothing>();
    }

    public ConcurrentHashSet(int initialCapacity) {
        this.delegate = new ConcurrentHashMap<E, Nothing>(initialCapacity);
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor) {
        this.delegate = new ConcurrentHashMap<E, Nothing>(initialCapacity, loadFactor);
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.delegate = new ConcurrentHashMap<E, Nothing>(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentHashSet(Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException("set must not be null");
        }
        this.delegate = new ConcurrentHashMap<E, Nothing>(Math.max(16, Math.round((float)c.size() * 1.5f)));
        for (E e : c) {
            this.delegate.put(e, Nothing.NOTHING);
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.keySet().toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.delegate.put(e, Nothing.NOTHING) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            changed &= this.delegate.put(e, Nothing.NOTHING) == null;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.keySet().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.keySet().removeAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    private static enum Nothing {
        NOTHING;

    }
}

