/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

public final class JedisUtils {
    private static final Logger log = LoggerFactory.getLogger(JedisUtils.class);
    public static final String PONG = "PONG";

    public static boolean ensureJedisConnection(Jedis jedis) {
        boolean jedisOK = JedisUtils.testJedisConnection(jedis);
        if (!jedisOK) {
            try {
                jedis.quit();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                jedis.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            jedis.connect();
        }
        return jedisOK;
    }

    public static boolean testJedisConnection(Jedis jedis) {
        boolean jedisOK = false;
        try {
            jedisOK = jedis.isConnected() && PONG.equals(jedis.ping());
        }
        catch (Exception e) {
            jedisOK = false;
        }
        return jedisOK;
    }

    public static boolean reconnect(Jedis jedis, int reconAttempts, long reconnectSleepTime) {
        int i = 1;
        do {
            try {
                jedis.disconnect();
                try {
                    Thread.sleep(reconnectSleepTime);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                jedis.connect();
            }
            catch (JedisConnectionException jce) {
            }
            catch (Exception e3) {
                log.error("Unknown Exception while trying to reconnect to Redis", (Throwable)e3);
            }
        } while (++i <= reconAttempts && !JedisUtils.testJedisConnection(jedis));
        return JedisUtils.testJedisConnection(jedis);
    }

    private JedisUtils() {
    }
}

