/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.utils.AmbiguousConstructorException;
import net.greghaines.jesque.utils.NoSuchConstructorException;
import net.greghaines.jesque.utils.ReflectionUtils;
import net.greghaines.jesque.worker.UnpermittedJobException;

public final class JesqueUtils {
    private static final String bTracePrefix = "\tat ";
    private static final String btCausedByPrefix = "Caused by: ";
    private static final String btUnknownSource = "Unknown Source";
    private static final String btNativeMethod = "Native Method";
    private static final Pattern btPattern = Pattern.compile("[\\(\\):]");
    private static final Pattern colonSpacePattern = Pattern.compile(":\\s");

    public static String join(String sep, String ... strs) {
        return JesqueUtils.join(sep, Arrays.asList(strs));
    }

    public static String join(String sep, Iterable<String> strs) {
        StringBuilder sb = new StringBuilder();
        String s = "";
        for (String str : strs) {
            sb.append(s).append(str);
            s = sep;
        }
        return sb.toString();
    }

    public static String createKey(String namespace, String ... parts) {
        return JesqueUtils.createKey(namespace, Arrays.asList(parts));
    }

    public static String createKey(String namespace, Iterable<String> parts) {
        LinkedList<String> list = new LinkedList<String>();
        list.add(namespace);
        for (String part : parts) {
            list.add(part);
        }
        return JesqueUtils.join(":", list);
    }

    public static List<String> createBacktrace(Throwable t) {
        LinkedList<String> bTrace = new LinkedList<String>();
        for (StackTraceElement ste : t.getStackTrace()) {
            bTrace.add(bTracePrefix + ste.toString());
        }
        if (t.getCause() != null) {
            JesqueUtils.addCauseToBacktrace(t.getCause(), bTrace);
        }
        return bTrace;
    }

    private static void addCauseToBacktrace(Throwable cause, List<String> bTrace) {
        if (cause.getMessage() == null) {
            bTrace.add(btCausedByPrefix + cause.getClass().getName());
        } else {
            bTrace.add(btCausedByPrefix + cause.getClass().getName() + ": " + cause.getMessage());
        }
        for (StackTraceElement ste : cause.getStackTrace()) {
            bTrace.add(bTracePrefix + ste.toString());
        }
        if (cause.getCause() != null) {
            JesqueUtils.addCauseToBacktrace(cause.getCause(), bTrace);
        }
    }

    public static Throwable recreateThrowable(String type, String message, List<String> backtrace) throws ParseException, ClassNotFoundException, NoSuchConstructorException, AmbiguousConstructorException, InstantiationException, IllegalAccessException, InvocationTargetException {
        LinkedList<String> bTrace = new LinkedList<String>(backtrace);
        Throwable cause = null;
        StackTraceElement[] stes = null;
        while (!bTrace.isEmpty()) {
            stes = JesqueUtils.recreateStackTrace(bTrace);
            if (bTrace.isEmpty()) continue;
            String line = bTrace.removeLast().substring(btCausedByPrefix.length());
            String[] classNameAndMsg = colonSpacePattern.split(line, 2);
            String msg = classNameAndMsg.length == 2 ? classNameAndMsg[1] : null;
            cause = JesqueUtils.instantiateThrowable(classNameAndMsg[0], msg, cause, stes);
        }
        return JesqueUtils.instantiateThrowable(type, message, cause, stes);
    }

    private static Throwable instantiateThrowable(String type, String message, Throwable cause, StackTraceElement[] stes) throws ClassNotFoundException, AmbiguousConstructorException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchConstructorException {
        Throwable t = null;
        boolean causeInited = false;
        Class<?> throwableType = ReflectionUtils.forName(type);
        if (message == null) {
            try {
                try {
                    t = (Throwable)ReflectionUtils.createObject(throwableType, new Object[0]);
                }
                catch (NoSuchConstructorException nsce2) {
                    if (cause == null) {
                        throw nsce2;
                    }
                    causeInited = true;
                    t = (Throwable)ReflectionUtils.createObject(throwableType, cause);
                }
            }
            catch (NoSuchConstructorException nsce) {
                try {
                    t = (Throwable)ReflectionUtils.createObject(throwableType, new Object[]{null});
                }
                catch (NoSuchConstructorException nsce3) {
                    if (cause == null) {
                        throw nsce3;
                    }
                    causeInited = true;
                    t = (Throwable)ReflectionUtils.createObject(throwableType, null, cause);
                }
            }
        } else {
            try {
                t = (Throwable)ReflectionUtils.createObject(throwableType, message);
            }
            catch (NoSuchConstructorException nsce) {
                if (cause == null) {
                    throw nsce;
                }
                causeInited = true;
                t = (Throwable)ReflectionUtils.createObject(throwableType, message, cause);
            }
        }
        t.setStackTrace(stes);
        if (!causeInited && cause != null) {
            t.initCause(cause);
        }
        return t;
    }

    private static StackTraceElement[] recreateStackTrace(List<String> bTrace) throws ParseException {
        String prev;
        LinkedList<StackTraceElement> stes = new LinkedList<StackTraceElement>();
        ListIterator<String> iter = bTrace.listIterator(bTrace.size());
        while (iter.hasPrevious() && (prev = iter.previous()).startsWith(bTracePrefix)) {
            int lineNumber;
            String fileName;
            iter.remove();
            String[] stParts = btPattern.split(prev.substring(bTracePrefix.length()));
            if (stParts.length < 2 || stParts.length > 3) {
                throw new ParseException("Malformed stack trace element string: " + prev, 0);
            }
            int periodPos = stParts[0].lastIndexOf(46);
            String className = stParts[0].substring(0, periodPos);
            String methodName = stParts[0].substring(periodPos + 1);
            if (btUnknownSource.equals(stParts[1])) {
                fileName = null;
                lineNumber = -1;
            } else if (btNativeMethod.equals(stParts[1])) {
                fileName = null;
                lineNumber = -2;
            } else {
                fileName = stParts[1];
                lineNumber = stParts.length == 3 ? Integer.parseInt(stParts[2]) : -1;
            }
            stes.add(0, new StackTraceElement(className, methodName, fileName, lineNumber));
        }
        return stes.toArray(new StackTraceElement[stes.size()]);
    }

    public static <K, V> Map<K, V> map(Map.Entry<? extends K, ? extends V> ... entries) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(entries.length);
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <K> Set<K> set(K ... keys) {
        return new LinkedHashSet<K>(Arrays.asList(keys));
    }

    public static Object materializeJob(Job job) throws ClassNotFoundException, Exception {
        Class<?> clazz = ReflectionUtils.forName(job.getClassName());
        if (!Runnable.class.isAssignableFrom(clazz) && !Callable.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("jobs must be a Runnable or a Callable: " + clazz.getName() + " - " + job);
        }
        return ReflectionUtils.createObject(clazz, job.getArgs());
    }

    public static Object materializeJob(Job job, Map<String, Class<?>> jobTypes) throws UnpermittedJobException, Exception {
        String className = job.getClassName();
        Class<?> clazz = jobTypes.get(className);
        if (clazz == null) {
            throw new UnpermittedJobException(className);
        }
        if (!Runnable.class.isAssignableFrom(clazz) && !Callable.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("jobs must be a Runnable or a Callable: " + clazz.getName() + " - " + job);
        }
        return ReflectionUtils.createObject(clazz, job.getArgs());
    }

    private JesqueUtils() {
    }
}

