/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import net.greghaines.jesque.Config;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.util.Pool;

public final class PoolUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, V> V doWorkInPool(Pool<T> pool, PoolWork<T, V> work) throws Exception {
        V result;
        if (pool == null) {
            throw new IllegalArgumentException("pool must not be null");
        }
        if (work == null) {
            throw new IllegalArgumentException("work must not be null");
        }
        Object poolResource = pool.getResource();
        try {
            result = work.doWork(poolResource);
        }
        finally {
            pool.returnResource(poolResource);
        }
        return result;
    }

    public static <T, V> V doWorkInPoolNicely(Pool<T> pool, PoolWork<T, V> work) {
        V result;
        try {
            result = PoolUtils.doWorkInPool(pool, work);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static GenericObjectPool.Config getDefaultPoolConfig() {
        GenericObjectPool.Config cfg = new GenericObjectPool.Config();
        cfg.maxActive = -1;
        cfg.maxIdle = 10;
        cfg.minIdle = 1;
        cfg.testOnBorrow = true;
        cfg.whenExhaustedAction = (byte)2;
        return cfg;
    }

    public static Pool<Jedis> createJedisPool(Config jesqueConfig) {
        return PoolUtils.createJedisPool(jesqueConfig, PoolUtils.getDefaultPoolConfig());
    }

    public static Pool<Jedis> createJedisPool(Config jesqueConfig, GenericObjectPool.Config poolConfig) {
        if (jesqueConfig == null) {
            throw new IllegalArgumentException("jesqueConfig must not be null");
        }
        if (poolConfig == null) {
            throw new IllegalArgumentException("poolConfig must not be null");
        }
        return new JedisPool(poolConfig, jesqueConfig.getHost(), jesqueConfig.getPort(), jesqueConfig.getTimeout(), jesqueConfig.getPassword());
    }

    private PoolUtils() {
    }

    public static interface PoolWork<T, V> {
        public V doWork(T var1) throws Exception;
    }
}

