/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionUtils {
    public static final String SNAPSHOT = "SNAPSHOT";
    public static final String DEVELOPMENT = "DEVELOPMENT";
    public static final String ERROR = "ERROR";
    private static final Logger log = LoggerFactory.getLogger(VersionUtils.class);
    private static final String pomPropertiesResName = "/META-INF/maven/net.greghaines/jesque/pom.properties";
    private static final String versionPropName = "version";
    private static final AtomicReference<String> versionRef = new AtomicReference<Object>(null);
    private static final Pattern dotPattern = Pattern.compile("[\\.-]");

    public static String getVersion() {
        String version = versionRef.get();
        if (version == null) {
            versionRef.set(VersionUtils.readVersion());
            version = versionRef.get();
        }
        return version;
    }

    public static Object[] getVersionParts() {
        String version = VersionUtils.getVersion();
        Object[] versionParts = new Object[4];
        if (DEVELOPMENT.equals(version) || ERROR.equals(version)) {
            versionParts[0] = -1;
            versionParts[1] = -1;
            versionParts[2] = -1;
            versionParts[3] = version;
        } else {
            String[] versionStrParts = dotPattern.split(version);
            boolean isSnapshot = versionStrParts.length == 4;
            int stop = isSnapshot ? versionStrParts.length - 1 : versionStrParts.length;
            for (int i = 0; i < stop; ++i) {
                versionParts[i] = Integer.valueOf(versionStrParts[i]);
            }
            if (isSnapshot) {
                versionParts[versionStrParts.length - 1] = versionStrParts[versionStrParts.length - 1];
            }
        }
        return versionParts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readVersion() {
        String version = DEVELOPMENT;
        InputStream stream = VersionUtils.class.getResourceAsStream(pomPropertiesResName);
        if (stream != null) {
            try {
                Properties props = new Properties();
                props.load(stream);
                version = (String)props.get(versionPropName);
            }
            catch (Exception e) {
                log.warn("Could not determine version from POM properties", (Throwable)e);
                version = ERROR;
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return version;
    }

    private VersionUtils() {
    }
}

