/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.worker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.greghaines.jesque.worker.ExceptionHandler;
import net.greghaines.jesque.worker.Worker;
import net.greghaines.jesque.worker.WorkerEvent;
import net.greghaines.jesque.worker.WorkerListener;

public class WorkerPool
implements Worker {
    private final List<Worker> workers;
    private final List<Thread> threads;

    public WorkerPool(Callable<? extends Worker> workerFactory, int numWorkers) {
        this(workerFactory, numWorkers, Executors.defaultThreadFactory());
    }

    public WorkerPool(Callable<? extends Worker> workerFactory, int numWorkers, ThreadFactory threadFactory) {
        this.workers = new ArrayList<Worker>(numWorkers);
        this.threads = new ArrayList<Thread>(numWorkers);
        for (int i = 0; i < numWorkers; ++i) {
            try {
                Worker worker = workerFactory.call();
                this.workers.add(worker);
                this.threads.add(threadFactory.newThread(worker));
                continue;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void endAndJoin(boolean now, long millis) throws InterruptedException {
        this.end(now);
        this.join(millis);
    }

    @Override
    public void join(long millis) throws InterruptedException {
        for (Thread thread : this.threads) {
            thread.join(millis);
        }
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder(128 * this.threads.size());
        String prefix = "";
        for (Worker worker : this.workers) {
            sb.append(prefix).append(worker.getName());
            prefix = " | ";
        }
        return sb.toString();
    }

    @Override
    public void run() {
        for (Thread thread : this.threads) {
            thread.start();
        }
        Thread.yield();
    }

    @Override
    public void addListener(WorkerListener listener) {
        for (Worker worker : this.workers) {
            worker.addListener(listener);
        }
    }

    @Override
    public void addListener(WorkerListener listener, WorkerEvent ... events) {
        for (Worker worker : this.workers) {
            worker.addListener(listener, events);
        }
    }

    @Override
    public void removeListener(WorkerListener listener) {
        for (Worker worker : this.workers) {
            worker.removeListener(listener);
        }
    }

    @Override
    public void removeListener(WorkerListener listener, WorkerEvent ... events) {
        for (Worker worker : this.workers) {
            worker.removeListener(listener, events);
        }
    }

    @Override
    public void removeAllListeners() {
        for (Worker worker : this.workers) {
            worker.removeAllListeners();
        }
    }

    @Override
    public void removeAllListeners(WorkerEvent ... events) {
        for (Worker worker : this.workers) {
            worker.removeAllListeners(events);
        }
    }

    @Override
    public void end(boolean now) {
        for (Worker worker : this.workers) {
            worker.end(now);
        }
    }

    @Override
    public boolean isShutdown() {
        return this.workers.get(0).isShutdown();
    }

    @Override
    public boolean isPaused() {
        return this.workers.get(0).isPaused();
    }

    @Override
    public void togglePause(boolean paused) {
        for (Worker worker : this.workers) {
            worker.togglePause(paused);
        }
    }

    @Override
    public boolean isProcessingJob() {
        boolean processingJob = false;
        for (Worker worker : this.workers) {
            if (processingJob |= worker.isProcessingJob()) break;
        }
        return processingJob;
    }

    @Override
    public Collection<String> getQueues() {
        return this.workers.get(0).getQueues();
    }

    @Override
    public void addQueue(String queueName) {
        for (Worker worker : this.workers) {
            worker.addQueue(queueName);
        }
    }

    @Override
    public void removeQueue(String queueName, boolean all) {
        for (Worker worker : this.workers) {
            worker.removeQueue(queueName, all);
        }
    }

    @Override
    public void removeAllQueues() {
        for (Worker worker : this.workers) {
            worker.removeAllQueues();
        }
    }

    @Override
    public void setQueues(Collection<String> queues) {
        for (Worker worker : this.workers) {
            worker.setQueues(queues);
        }
    }

    @Override
    public Map<String, Class<?>> getJobTypes() {
        return this.workers.get(0).getJobTypes();
    }

    @Override
    public void addJobType(String jobName, Class<?> jobType) {
        for (Worker worker : this.workers) {
            worker.addJobType(jobName, jobType);
        }
    }

    @Override
    public void removeJobType(Class<?> jobType) {
        for (Worker worker : this.workers) {
            worker.removeJobType(jobType);
        }
    }

    @Override
    public void removeJobName(String jobName) {
        for (Worker worker : this.workers) {
            worker.removeJobName(jobName);
        }
    }

    @Override
    public void setJobTypes(Map<String, ? extends Class<?>> jobTypes) {
        for (Worker worker : this.workers) {
            worker.setJobTypes(jobTypes);
        }
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.workers.get(0).getExceptionHandler();
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        for (Worker worker : this.workers) {
            worker.setExceptionHandler(exceptionHandler);
        }
    }
}

