/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque;

import java.io.Serializable;
import java.util.Set;
import net.greghaines.jesque.utils.JesqueUtils;

public class Config
implements Serializable {
    private static final long serialVersionUID = -6638770587683679373L;
    private final String host;
    private final int port;
    private final int timeout;
    private final String password;
    private final String namespace;
    private final int database;
    private final Set<String> sentinels;
    private final String masterName;

    public Config(String host, int port, int timeout, String password, String namespace, int database) {
        if (host == null || "".equals(host)) {
            throw new IllegalArgumentException("host must not be null or empty: " + host);
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("post must be a valid port in the range 1-65535: " + port);
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must not be negative: " + timeout);
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace must not be null");
        }
        if (database < 0) {
            throw new IllegalArgumentException("database must not be negative: " + database);
        }
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.password = password;
        this.namespace = namespace;
        this.database = database;
        this.sentinels = null;
        this.masterName = null;
    }

    public Config(Set<String> sentinels, String masterName, int timeout, String password, String namespace, int database) {
        if (sentinels == null || sentinels.size() < 1) {
            throw new IllegalArgumentException("sentinels must not be null or empty: " + sentinels);
        }
        if (masterName == null || "".equals(masterName)) {
            throw new IllegalArgumentException("master must not be null or empty: " + masterName);
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must not be negative: " + timeout);
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace must not be null");
        }
        if (database < 0) {
            throw new IllegalArgumentException("database must not be negative: " + database);
        }
        this.sentinels = sentinels;
        this.masterName = masterName;
        this.timeout = timeout;
        this.password = password;
        this.namespace = namespace;
        this.database = database;
        this.host = "localhost";
        this.port = 6379;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getDatabase() {
        return this.database;
    }

    public Set<String> getSentinels() {
        return this.sentinels;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public String getURI() {
        return "redis://" + this.host + ":" + this.port + "/" + this.database;
    }

    public String toString() {
        return "<" + this.getURI() + " namespace=" + this.namespace + " timeout=" + this.timeout + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.database;
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.namespace.hashCode();
        result = 31 * result + (this.sentinels == null ? 0 : this.sentinels.hashCode());
        result = 31 * result + (this.masterName == null ? 0 : this.masterName.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + this.timeout;
        return result;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (this == obj) {
            equal = true;
        } else if (obj instanceof Config) {
            Config other = (Config)obj;
            equal = this.database == other.database && this.port == other.port && this.timeout == other.timeout && JesqueUtils.nullSafeEquals(this.host, other.host) && JesqueUtils.nullSafeEquals(this.namespace, other.namespace) && JesqueUtils.nullSafeEquals(this.sentinels, other.sentinels) && JesqueUtils.nullSafeEquals(this.masterName, other.masterName);
        }
        return equal;
    }
}

