/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.meta.dao.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.greghaines.jesque.Config;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.JobFailure;
import net.greghaines.jesque.json.ObjectMapperFactory;
import net.greghaines.jesque.meta.dao.FailureDAO;
import net.greghaines.jesque.utils.JesqueUtils;
import net.greghaines.jesque.utils.PoolUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.Pool;

public class FailureDAORedisImpl
implements FailureDAO {
    private final Config config;
    private final Pool<Jedis> jedisPool;

    public FailureDAORedisImpl(Config config, Pool<Jedis> jedisPool) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (jedisPool == null) {
            throw new IllegalArgumentException("jedisPool must not be null");
        }
        this.config = config;
        this.jedisPool = jedisPool;
    }

    @Override
    public long getCount() {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Long>(){

            @Override
            public Long doWork(Jedis jedis) throws Exception {
                String failedStr = jedis.get(FailureDAORedisImpl.this.key(new String[]{"stat", "failed"}));
                return failedStr == null ? 0L : Long.parseLong(failedStr);
            }
        });
    }

    @Override
    public long getFailQueueJobCount() {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Long>(){

            @Override
            public Long doWork(Jedis jedis) throws Exception {
                return jedis.llen(FailureDAORedisImpl.this.key(new String[]{"failed"}));
            }
        });
    }

    @Override
    public List<JobFailure> getFailures(final long offset, final long count) {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, List<JobFailure>>(){

            @Override
            public List<JobFailure> doWork(Jedis jedis) throws Exception {
                List payloads = jedis.lrange(FailureDAORedisImpl.this.key(new String[]{"failed"}), offset, offset + count - 1L);
                ArrayList<JobFailure> failures = new ArrayList<JobFailure>(payloads.size());
                for (String payload : payloads) {
                    if (payload.charAt(0) != '{') continue;
                    failures.add((JobFailure)ObjectMapperFactory.get().readValue(payload, JobFailure.class));
                }
                return failures;
            }
        });
    }

    @Override
    public void clear() {
        PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

            @Override
            public Void doWork(Jedis jedis) throws Exception {
                jedis.del(FailureDAORedisImpl.this.key(new String[]{"failed"}));
                return null;
            }
        });
    }

    @Override
    public Date requeue(final long index) {
        Date retryDate = null;
        final List<JobFailure> failures = this.getFailures(index, 1L);
        if (!failures.isEmpty()) {
            retryDate = PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Date>(){

                @Override
                public Date doWork(Jedis jedis) throws Exception {
                    Date retriedAt = new Date();
                    JobFailure failure = (JobFailure)failures.get(0);
                    failure.setRetriedAt(retriedAt);
                    jedis.lset(FailureDAORedisImpl.this.key(new String[]{"failed"}), index, ObjectMapperFactory.get().writeValueAsString((Object)failure));
                    FailureDAORedisImpl.this.enqueue(jedis, failure.getQueue(), failure.getPayload());
                    return retriedAt;
                }
            });
        }
        return retryDate;
    }

    @Override
    public void remove(final long index) {
        PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

            @Override
            public Void doWork(Jedis jedis) throws Exception {
                String failedKey = FailureDAORedisImpl.this.key(new String[]{"failed"});
                String randId = UUID.randomUUID().toString();
                jedis.lset(failedKey, index, randId);
                jedis.lrem(failedKey, 1L, randId);
                return null;
            }
        });
    }

    protected void enqueue(Jedis jedis, String queue, Job job) throws IOException {
        if (queue == null || "".equals(queue)) {
            throw new IllegalArgumentException("queue must not be null or empty: " + queue);
        }
        if (job == null) {
            throw new IllegalArgumentException("job must not be null");
        }
        if (!job.isValid()) {
            throw new IllegalStateException("job is not valid: " + job);
        }
        String msg = ObjectMapperFactory.get().writeValueAsString((Object)job);
        jedis.sadd(this.key("queues"), new String[]{queue});
        jedis.rpush(this.key("queue", queue), new String[]{msg});
    }

    private String key(String ... parts) {
        return JesqueUtils.createKey(this.config.getNamespace(), parts);
    }
}

