/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.meta.dao.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.greghaines.jesque.Config;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.json.ObjectMapperFactory;
import net.greghaines.jesque.meta.QueueInfo;
import net.greghaines.jesque.meta.dao.QueueInfoDAO;
import net.greghaines.jesque.utils.JedisUtils;
import net.greghaines.jesque.utils.JesqueUtils;
import net.greghaines.jesque.utils.PoolUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.util.Pool;

public class QueueInfoDAORedisImpl
implements QueueInfoDAO {
    private final Config config;
    private final Pool<Jedis> jedisPool;

    public QueueInfoDAORedisImpl(Config config, Pool<Jedis> jedisPool) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (jedisPool == null) {
            throw new IllegalArgumentException("jedisPool must not be null");
        }
        this.config = config;
        this.jedisPool = jedisPool;
    }

    @Override
    public List<String> getQueueNames() {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, List<String>>(){

            @Override
            public List<String> doWork(Jedis jedis) throws Exception {
                ArrayList<String> queueNames = new ArrayList<String>(jedis.smembers(QueueInfoDAORedisImpl.this.key(new String[]{"queues"})));
                Collections.sort(queueNames);
                return queueNames;
            }
        });
    }

    @Override
    public long getPendingCount() {
        final List<String> queueNames = this.getQueueNames();
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Long>(){

            @Override
            public Long doWork(Jedis jedis) throws Exception {
                long pendingCount = 0L;
                for (String queueName : queueNames) {
                    pendingCount += QueueInfoDAORedisImpl.this.size(jedis, queueName);
                }
                return pendingCount;
            }
        });
    }

    @Override
    public long getProcessedCount() {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Long>(){

            @Override
            public Long doWork(Jedis jedis) throws Exception {
                String processedStr = jedis.get(QueueInfoDAORedisImpl.this.key(new String[]{"stat", "processed"}));
                return processedStr == null ? 0L : Long.parseLong(processedStr);
            }
        });
    }

    @Override
    public List<QueueInfo> getQueueInfos() {
        final List<String> queueNames = this.getQueueNames();
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, List<QueueInfo>>(){

            @Override
            public List<QueueInfo> doWork(Jedis jedis) throws Exception {
                ArrayList<QueueInfo> queueInfos = new ArrayList<QueueInfo>(queueNames.size());
                for (String queueName : queueNames) {
                    QueueInfo queueInfo = new QueueInfo();
                    queueInfo.setName(queueName);
                    queueInfo.setSize(QueueInfoDAORedisImpl.this.size(jedis, queueName));
                    queueInfo.setDelayed(QueueInfoDAORedisImpl.this.delayed(jedis, queueName));
                    if (queueInfo.isDelayed().booleanValue()) {
                        queueInfo.setPending(QueueInfoDAORedisImpl.this.pending(jedis, queueName));
                    }
                    queueInfos.add(queueInfo);
                }
                Collections.sort(queueInfos);
                return queueInfos;
            }
        });
    }

    @Override
    public QueueInfo getQueueInfo(final String name, final long jobOffset, final long jobCount) {
        return PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, QueueInfo>(){

            @Override
            public QueueInfo doWork(Jedis jedis) throws Exception {
                QueueInfo queueInfo = new QueueInfo();
                queueInfo.setName(name);
                queueInfo.setSize(QueueInfoDAORedisImpl.this.size(jedis, name));
                queueInfo.setDelayed(QueueInfoDAORedisImpl.this.delayed(jedis, name));
                if (queueInfo.isDelayed().booleanValue()) {
                    queueInfo.setPending(QueueInfoDAORedisImpl.this.pending(jedis, name));
                }
                List jobs = QueueInfoDAORedisImpl.this.getJobs(jedis, name, jobOffset, jobCount);
                queueInfo.setJobs(jobs);
                return queueInfo;
            }
        });
    }

    private boolean delayed(Jedis jedis, String queueName) {
        String key = this.key("queue", queueName);
        return JedisUtils.isDelayedQueue(jedis, key);
    }

    @Override
    public void removeQueue(final String name) {
        PoolUtils.doWorkInPoolNicely(this.jedisPool, new PoolUtils.PoolWork<Jedis, Void>(){

            @Override
            public Void doWork(Jedis jedis) throws Exception {
                jedis.srem(QueueInfoDAORedisImpl.this.key(new String[]{"queues"}), new String[]{name});
                jedis.del(QueueInfoDAORedisImpl.this.key(new String[]{"queue", name}));
                return null;
            }
        });
    }

    private String key(String ... parts) {
        return JesqueUtils.createKey(this.config.getNamespace(), parts);
    }

    private long size(Jedis jedis, String queueName) {
        String key = this.key("queue", queueName);
        long size = JedisUtils.isDelayedQueue(jedis, key) ? jedis.zcard(key).longValue() : jedis.llen(key).longValue();
        return size;
    }

    private long pending(Jedis jedis, String queueName) {
        String key = this.key("queue", queueName);
        return jedis.zcount(key, 0.0, (double)System.currentTimeMillis());
    }

    private List<Job> getJobs(Jedis jedis, String queueName, long jobOffset, long jobCount) throws Exception {
        String key = this.key("queue", queueName);
        ArrayList<Job> jobs = new ArrayList<Job>();
        if (JedisUtils.isDelayedQueue(jedis, key)) {
            Set elements = jedis.zrangeWithScores(key, jobOffset, jobOffset + jobCount - 1L);
            for (Tuple elementWithScore : elements) {
                Job job = (Job)ObjectMapperFactory.get().readValue(elementWithScore.getElement(), Job.class);
                job.setRunAt(elementWithScore.getScore());
                jobs.add(job);
            }
        } else {
            List elements = jedis.lrange(key, jobOffset, jobOffset + jobCount - 1L);
            for (String element : elements) {
                jobs.add((Job)ObjectMapperFactory.get().readValue(element, Job.class));
            }
        }
        return jobs;
    }
}

