/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import net.greghaines.jesque.utils.ResqueDateFormatThreadLocal;

public class CompositeDateFormat
extends DateFormat {
    private static final long serialVersionUID = -4079876635509458541L;
    private static final List<DateFormatFactory> DATE_FORMAT_FACTORIES = Arrays.asList(new DateFormatFactory(){

        @Override
        public DateFormat create() {
            return ResqueDateFormatThreadLocal.getInstance();
        }
    }, new PatternDateFormatFactory("yyyy-MM-dd HH:mm:ss Z"), new PatternDateFormatFactory("yyyy-MM-dd HH:mm:ss"), new PatternDateFormatFactory("yyyy/MM/dd HH:mm:ss Z"), new PatternDateFormatFactory("yyyy/MM/dd HH:mm:ss"), new PatternDateFormatFactory("EEE MMM dd HH:mm:ss z yyyy"));

    public CompositeDateFormat() {
        this.setCalendar(new GregorianCalendar());
        this.setNumberFormat(new DecimalFormat());
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return ResqueDateFormatThreadLocal.getInstance().format(date, toAppendTo, fieldPosition);
    }

    @Override
    public Date parse(String dateStr, ParsePosition pos) {
        ParsePosition posCopy = new ParsePosition(pos.getIndex());
        Date date = null;
        boolean success = false;
        for (DateFormatFactory dfFactory : DATE_FORMAT_FACTORIES) {
            posCopy.setIndex(pos.getIndex());
            posCopy.setErrorIndex(pos.getErrorIndex());
            date = dfFactory.create().parse(dateStr, posCopy);
            if (date == null) continue;
            success = true;
            break;
        }
        if (success) {
            pos.setIndex(posCopy.getIndex());
            pos.setErrorIndex(posCopy.getErrorIndex());
        }
        return date;
    }

    private static interface DateFormatFactory {
        public DateFormat create();
    }

    private static class PatternDateFormatFactory
    implements DateFormatFactory,
    Serializable {
        private static final long serialVersionUID = 3382491374377384377L;
        private final String pattern;

        public PatternDateFormatFactory(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public DateFormat create() {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.pattern, Locale.US);
            dateFormat.setLenient(false);
            return dateFormat;
        }

        public String toString() {
            return "PatternDateFormatFactory [pattern=" + this.pattern + "]";
        }
    }
}

