/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

public final class JedisUtils {
    public static final String PONG = "PONG";
    private static final Logger LOG = LoggerFactory.getLogger(JedisUtils.class);
    private static final String LIST = "list";
    private static final String ZSET = "zset";
    private static final String HASH = "hash";
    private static final String NONE = "none";

    public static boolean ensureJedisConnection(Jedis jedis) {
        boolean jedisOK = JedisUtils.testJedisConnection(jedis);
        if (!jedisOK) {
            try {
                jedis.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                jedis.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            jedis.connect();
        }
        return jedisOK;
    }

    public static boolean testJedisConnection(Jedis jedis) {
        boolean jedisOK = false;
        try {
            jedisOK = jedis.isConnected() && PONG.equals(jedis.ping());
        }
        catch (Exception e) {
            jedisOK = false;
        }
        return jedisOK;
    }

    public static boolean reconnect(Jedis jedis, int reconAttempts, long reconnectSleepTime) {
        int i = 1;
        do {
            try {
                jedis.disconnect();
                try {
                    Thread.sleep(reconnectSleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jedis.connect();
            }
            catch (JedisConnectionException jedisConnectionException) {
            }
            catch (Exception e3) {
                LOG.error("Unknown Exception while trying to reconnect to Redis", (Throwable)e3);
            }
        } while (++i <= reconAttempts && !JedisUtils.testJedisConnection(jedis));
        return JedisUtils.testJedisConnection(jedis);
    }

    public static boolean isRegularQueue(Jedis jedis, String key) {
        return LIST.equalsIgnoreCase(jedis.type(key));
    }

    public static boolean isDelayedQueue(Jedis jedis, String key) {
        return ZSET.equalsIgnoreCase(jedis.type(key));
    }

    public static boolean isRecurringQueue(Jedis jedis, String queueKey, String hashKey) {
        String hashType = jedis.type(hashKey);
        return JedisUtils.isDelayedQueue(jedis, queueKey) && HASH.equalsIgnoreCase(hashType);
    }

    public static boolean isKeyUsed(Jedis jedis, String key) {
        return !NONE.equalsIgnoreCase(jedis.type(key));
    }

    public static boolean canUseAsDelayedQueue(Jedis jedis, String key) {
        String type = jedis.type(key);
        return ZSET.equalsIgnoreCase(type) || NONE.equalsIgnoreCase(type);
    }

    public static boolean canUseAsRecurringQueue(Jedis jedis, String queueKey, String hashKey) {
        String hashType = jedis.type(hashKey);
        return JedisUtils.canUseAsDelayedQueue(jedis, queueKey) && (HASH.equalsIgnoreCase(hashType) || NONE.equalsIgnoreCase(hashType));
    }

    private JedisUtils() {
    }
}

