/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import net.greghaines.jesque.Config;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.util.Pool;

public final class PoolUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V doWorkInPool(Pool<Jedis> pool, PoolWork<Jedis, V> work) throws Exception {
        V result;
        if (pool == null) {
            throw new IllegalArgumentException("pool must not be null");
        }
        if (work == null) {
            throw new IllegalArgumentException("work must not be null");
        }
        try (Jedis poolResource = (Jedis)pool.getResource();){
            result = work.doWork(poolResource);
        }
        return result;
    }

    public static <V> V doWorkInPoolNicely(Pool<Jedis> pool, PoolWork<Jedis, V> work) {
        V result;
        try {
            result = PoolUtils.doWorkInPool(pool, work);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static GenericObjectPoolConfig getDefaultPoolConfig() {
        GenericObjectPoolConfig cfg = new GenericObjectPoolConfig();
        cfg.setMaxTotal(-1);
        cfg.setMaxIdle(10);
        cfg.setMinIdle(1);
        cfg.setTestOnBorrow(true);
        cfg.setBlockWhenExhausted(false);
        return cfg;
    }

    public static Pool<Jedis> createJedisPool(Config jesqueConfig) {
        return PoolUtils.createJedisPool(jesqueConfig, PoolUtils.getDefaultPoolConfig());
    }

    public static Pool<Jedis> createJedisPool(Config jesqueConfig, GenericObjectPoolConfig poolConfig) {
        if (jesqueConfig == null) {
            throw new IllegalArgumentException("jesqueConfig must not be null");
        }
        if (poolConfig == null) {
            throw new IllegalArgumentException("poolConfig must not be null");
        }
        if (jesqueConfig.getMasterName() != null && !"".equals(jesqueConfig.getMasterName()) && jesqueConfig.getSentinels() != null && jesqueConfig.getSentinels().size() > 0) {
            return new JedisSentinelPool(jesqueConfig.getMasterName(), jesqueConfig.getSentinels(), poolConfig, jesqueConfig.getTimeout(), jesqueConfig.getPassword(), jesqueConfig.getDatabase());
        }
        return new JedisPool(poolConfig, jesqueConfig.getHost(), jesqueConfig.getPort(), jesqueConfig.getTimeout(), jesqueConfig.getPassword(), jesqueConfig.getDatabase());
    }

    private PoolUtils() {
    }

    public static interface PoolWork<T, V> {
        public V doWork(T var1) throws Exception;
    }
}

