/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.greghaines.jesque.utils.AmbiguousConstructorException;
import net.greghaines.jesque.utils.NoSuchConstructorException;

public final class ReflectionUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final Map<Class<?>, Class<?>> wrapperTypeToPrimitiveMap = new HashMap(8);
    private static final Map<Class<?>, Class<?>> primitiveTypeToWrapperMap = new HashMap(8);
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(16);
    private static final Map<String, Class<?>> commonClassCache = new HashMap(32);

    public static <T> T createObject(Class<T> clazz, Object ... args) throws NoSuchConstructorException, AmbiguousConstructorException, ReflectiveOperationException {
        return ReflectionUtils.findConstructor(clazz, args).newInstance(args);
    }

    public static <T> T createObject(Class<T> clazz, Object[] args, Map<String, Object> vars) throws NoSuchConstructorException, AmbiguousConstructorException, ReflectiveOperationException {
        return ReflectionUtils.invokeSetters(ReflectionUtils.findConstructor(clazz, args).newInstance(args), vars);
    }

    private static <T> Constructor<T> findConstructor(Class<T> clazz, Object ... args) throws NoSuchConstructorException, AmbiguousConstructorException {
        Object[] cArgs = args == null ? new Object[]{} : args;
        Constructor<?> constructorToUse = null;
        Constructor<?>[] candidates = clazz.getConstructors();
        Arrays.sort(candidates, ConstructorComparator.INSTANCE);
        int minTypeDiffWeight = Integer.MAX_VALUE;
        LinkedHashSet ambiguousConstructors = null;
        for (Constructor<?> candidate : candidates) {
            Class[] paramTypes = candidate.getParameterTypes();
            if (constructorToUse != null && cArgs.length > paramTypes.length) break;
            if (paramTypes.length != cArgs.length) continue;
            int typeDiffWeight = ReflectionUtils.getTypeDifferenceWeight(paramTypes, cArgs);
            if (typeDiffWeight < minTypeDiffWeight) {
                constructorToUse = candidate;
                minTypeDiffWeight = typeDiffWeight;
                ambiguousConstructors = null;
                continue;
            }
            if (constructorToUse == null || typeDiffWeight != minTypeDiffWeight) continue;
            if (ambiguousConstructors == null) {
                ambiguousConstructors = new LinkedHashSet();
                ambiguousConstructors.add(constructorToUse);
            }
            ambiguousConstructors.add(candidate);
        }
        if (ambiguousConstructors != null && !ambiguousConstructors.isEmpty()) {
            throw new AmbiguousConstructorException(clazz, cArgs, ambiguousConstructors);
        }
        if (constructorToUse == null) {
            throw new NoSuchConstructorException(clazz, cArgs);
        }
        return constructorToUse;
    }

    private static int getTypeDifferenceWeight(Class[] paramTypes, Object[] args) {
        int result = 0;
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!ReflectionUtils.isAssignableValue(paramTypes[i], args[i])) {
                return Integer.MAX_VALUE;
            }
            if (args[i] == null) continue;
            Class paramType = paramTypes[i];
            Class<?> superClass = args[i].getClass().getSuperclass();
            while (superClass != null) {
                if (paramType.equals(superClass)) {
                    result += 2;
                    superClass = null;
                    continue;
                }
                if (ReflectionUtils.isAssignable(paramType, superClass)) {
                    result += 2;
                    superClass = superClass.getSuperclass();
                    continue;
                }
                superClass = null;
            }
            if (!paramType.isInterface()) continue;
            ++result;
        }
        return result;
    }

    public static boolean isAssignable(Class<?> lhsType, Class<?> rhsType) {
        Class<?> resolvedWrapper;
        Class<?> resolvedPrimitive;
        boolean assignable = lhsType.isAssignableFrom(rhsType) ? true : (lhsType.isPrimitive() ? (resolvedPrimitive = wrapperTypeToPrimitiveMap.get(rhsType)) != null && lhsType.equals(resolvedPrimitive) : (resolvedWrapper = primitiveTypeToWrapperMap.get(rhsType)) != null && lhsType.isAssignableFrom(resolvedWrapper));
        return assignable;
    }

    public static boolean isAssignableValue(Class<?> type, Object value) {
        return value != null ? ReflectionUtils.isAssignable(type, value.getClass()) : !type.isPrimitive();
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cl == null) {
            cl = ReflectionUtils.class.getClassLoader();
        }
        return cl;
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        return ReflectionUtils.forName(name, ReflectionUtils.getDefaultClassLoader());
    }

    public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Class<?> clazz = ReflectionUtils.resolvePrimitiveClassName(name);
        if (clazz == null) {
            clazz = commonClassCache.get(name);
        }
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ReflectionUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
            String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
            Class<?> elementClass = ReflectionUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
            String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
            Class<?> elementClass = ReflectionUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        ClassLoader classLoaderToUse = classLoader == null ? ReflectionUtils.getDefaultClassLoader() : classLoader;
        try {
            return classLoaderToUse.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
                try {
                    return classLoaderToUse.loadClass(innerClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    private static Class<?> resolvePrimitiveClassName(String name) {
        Class<?> result = null;
        if (name != null && name.length() <= 8) {
            result = primitiveTypeNameMap.get(name);
        }
        return result;
    }

    public static <T> T invokeSetters(T instance, Map<String, Object> vars) throws ReflectiveOperationException {
        if (instance != null && vars != null) {
            Class<?> clazz = instance.getClass();
            Method[] methods = clazz.getMethods();
            for (Map.Entry<String, Object> entry : vars.entrySet()) {
                String methodName = "set" + entry.getKey().substring(0, 1).toUpperCase(Locale.US) + entry.getKey().substring(1);
                boolean found = false;
                for (Method method : methods) {
                    if (!methodName.equals(method.getName()) || method.getParameterTypes().length != 1) continue;
                    method.invoke(instance, entry.getValue());
                    found = true;
                    break;
                }
                if (found) continue;
                throw new NoSuchMethodException("Expected setter named '" + methodName + "' for var '" + entry.getKey() + "'");
            }
        }
        return instance;
    }

    private ReflectionUtils() {
    }

    static {
        wrapperTypeToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        wrapperTypeToPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperTypeToPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperTypeToPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperTypeToPrimitiveMap.put(Float.class, Float.TYPE);
        wrapperTypeToPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperTypeToPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperTypeToPrimitiveMap.put(Short.class, Short.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry : wrapperTypeToPrimitiveMap.entrySet()) {
            primitiveTypeToWrapperMap.put(entry.getValue(), entry.getKey());
        }
        HashSet<Class> primitiveTypes = new HashSet<Class>(16);
        primitiveTypes.addAll(wrapperTypeToPrimitiveMap.values());
        primitiveTypes.addAll(Arrays.asList(boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class));
        for (Class primitiveType : primitiveTypes) {
            primitiveTypeNameMap.put(primitiveType.getName(), primitiveType);
        }
        List<Class> list = Arrays.asList(Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class, Number.class, Number[].class, String.class, String[].class, Object.class, Object[].class, Class.class, Class[].class, Throwable.class, Exception.class, RuntimeException.class, Error.class, StackTraceElement.class, StackTraceElement[].class);
        for (Class clazz : list) {
            commonClassCache.put(clazz.getName(), clazz);
        }
    }

    private static final class ConstructorComparator
    implements Comparator<Constructor<?>>,
    Serializable {
        private static final long serialVersionUID = 1338239669376657022L;
        public static final ConstructorComparator INSTANCE = new ConstructorComparator();

        private ConstructorComparator() {
        }

        @Override
        public int compare(Constructor<?> c1, Constructor<?> c2) {
            boolean p2;
            boolean p1 = Modifier.isPublic(c1.getModifiers());
            return p1 != (p2 = Modifier.isPublic(c2.getModifiers())) ? (p1 ? -1 : 1) : Integer.valueOf(c2.getParameterTypes().length).compareTo(c1.getParameterTypes().length);
        }
    }
}

