/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionUtils {
    public static final String DEVELOPMENT = "DEVELOPMENT";
    public static final String ERROR = "ERROR";
    private static final Logger LOG = LoggerFactory.getLogger(VersionUtils.class);
    private static final String POM_PROPERTIES_RES_NAME = "/META-INF/maven/net.greghaines/jesque/pom.properties";
    private static final String VERSION_PROP_NAME = "version";
    private static final AtomicReference<String> VERSION_REF = new AtomicReference<Object>(null);

    public static String getVersion() {
        String version = VERSION_REF.get();
        if (version == null) {
            VERSION_REF.set(VersionUtils.readVersion());
            version = VERSION_REF.get();
        }
        return version;
    }

    private static String readVersion() {
        String version = DEVELOPMENT;
        InputStream stream = VersionUtils.class.getResourceAsStream(POM_PROPERTIES_RES_NAME);
        if (stream != null) {
            try {
                Properties props = new Properties();
                props.load(stream);
                version = (String)props.get(VERSION_PROP_NAME);
            }
            catch (Exception e) {
                LOG.warn("Could not determine version from POM properties", (Throwable)e);
                version = ERROR;
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    LOG.debug("Error closing pom properties resource stream");
                }
            }
        }
        return version;
    }

    private VersionUtils() {
    }
}

