/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.worker;

import com.fasterxml.jackson.core.JsonProcessingException;
import net.greghaines.jesque.worker.ExceptionHandler;
import net.greghaines.jesque.worker.JobExecutor;
import net.greghaines.jesque.worker.RecoveryStrategy;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisNoScriptException;

public class DefaultPoolExceptionHandler
implements ExceptionHandler {
    @Override
    public RecoveryStrategy onException(JobExecutor jobExecutor, Exception exception, String curQueue) {
        boolean isLoadingDataset;
        boolean bl = isLoadingDataset = exception instanceof JedisDataException && exception.getMessage().startsWith("LOADING Redis is loading the dataset in memory");
        if (exception instanceof JedisConnectionException || exception instanceof JedisNoScriptException || isLoadingDataset) {
            return RecoveryStrategy.RECONNECT;
        }
        if (exception instanceof JsonProcessingException || exception instanceof InterruptedException && !jobExecutor.isShutdown()) {
            return RecoveryStrategy.PROCEED;
        }
        return RecoveryStrategy.TERMINATE;
    }
}

