/*
 * Decompiled with CFR 0.152.
 */
package net.greypanther.natsort;

import java.util.Comparator;

abstract class AbstractSimpleNaturalComparator<T extends CharSequence>
implements Comparator<T> {
    AbstractSimpleNaturalComparator() {
    }

    @Override
    public int compare(T sequence1, T sequence2) {
        int len1 = sequence1.length();
        int len2 = sequence2.length();
        int idx1 = 0;
        int idx2 = 0;
        while (idx1 < len1 && idx2 < len2) {
            char c1 = sequence1.charAt(idx1++);
            char c2 = sequence2.charAt(idx2++);
            boolean isDigit1 = AbstractSimpleNaturalComparator.isDigit(c1);
            boolean isDigit2 = AbstractSimpleNaturalComparator.isDigit(c2);
            if (isDigit1 && !isDigit2) {
                return -1;
            }
            if (!isDigit1 && isDigit2) {
                return 1;
            }
            if (!isDigit1 && !isDigit2) {
                int c = this.compareChars(c1, c2);
                if (c == 0) continue;
                return c;
            }
            long num1 = AbstractSimpleNaturalComparator.parse(c1);
            while (idx1 < len1) {
                char digit;
                if (AbstractSimpleNaturalComparator.isDigit(digit = sequence1.charAt(idx1++))) {
                    num1 = num1 * 10L + AbstractSimpleNaturalComparator.parse(digit);
                    continue;
                }
                --idx1;
                break;
            }
            long num2 = AbstractSimpleNaturalComparator.parse(c2);
            while (idx2 < len2) {
                char digit;
                if (AbstractSimpleNaturalComparator.isDigit(digit = sequence2.charAt(idx2++))) {
                    num2 = num2 * 10L + AbstractSimpleNaturalComparator.parse(digit);
                    continue;
                }
                --idx2;
                break;
            }
            if (num1 == num2) continue;
            return AbstractSimpleNaturalComparator.compareUnsigned(num1, num2);
        }
        if (idx1 < len1) {
            return 1;
        }
        if (idx2 < len2) {
            return -1;
        }
        return 0;
    }

    abstract int compareChars(char var1, char var2);

    private static int compareUnsigned(long num1, long num2) {
        return AbstractSimpleNaturalComparator.compare(num1 + Long.MIN_VALUE, num2 + Long.MIN_VALUE);
    }

    private static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static long parse(char c1) {
        return c1 - 48;
    }

    private static boolean isDigit(char c) {
        return '0' <= c & c <= '9';
    }
}

