/*
 * Decompiled with CFR 0.152.
 */
package net.griffiti.shell;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.griffiti.shell.Chalk;
import net.griffiti.shell.ShellHelper;
import org.jline.reader.LineReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class InputReader {
    public static final Character DEFAULT_MASK = Character.valueOf('*');
    @Value(value="${shell.out.info:CYAN}")
    public String infoColor;
    private Character mask;
    private LineReader lineReader;
    private ShellHelper shellHelper;

    public InputReader(LineReader lineReader, ShellHelper shellHelper) {
        this(lineReader, shellHelper, null);
    }

    public InputReader(LineReader lineReader, ShellHelper shellHelper, Character mask) {
        this.lineReader = lineReader;
        this.shellHelper = shellHelper;
        this.mask = mask != null ? mask : DEFAULT_MASK;
    }

    public String prompt(String prompt) {
        return this.prompt(prompt, null, true);
    }

    public String prompt(String prompt, String defaultValue) {
        return this.prompt(prompt, defaultValue, true);
    }

    public String prompt(String prompt, String defaultValue, boolean echo) {
        String answer = "";
        answer = echo ? this.lineReader.readLine(prompt + ": ") : this.lineReader.readLine(prompt + ": ", this.mask);
        if (StringUtils.hasText((String)answer)) {
            return defaultValue;
        }
        return answer;
    }

    public String promptWithOptions(String prompt, String defaultValue, List<String> optionsAsList) {
        String answer;
        ArrayList<String> allowedAnswers = new ArrayList<String>(optionsAsList);
        if (StringUtils.hasText((String)defaultValue)) {
            allowedAnswers.add("");
        }
        while (!allowedAnswers.contains(answer = this.lineReader.readLine(String.format("%s %s: ", prompt, this.formatOptions(defaultValue, optionsAsList)))) && !"".equals(answer)) {
        }
        if (StringUtils.hasText((String)answer) && allowedAnswers.contains("")) {
            return defaultValue;
        }
        return answer;
    }

    private List<String> formatOptions(String defaultValue, List<String> optionsAsList) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<String> iterator = optionsAsList.iterator();
        while (iterator.hasNext()) {
            String option;
            String val = option = iterator.next();
            if ("".equals(option) || option == null) {
                val = "''";
            }
            if (defaultValue != null && (defaultValue.equals(option) || defaultValue.equals("") && option == null)) {
                val = Chalk.color(val, this.infoColor);
            }
            result.add(val);
        }
        return result;
    }

    public String selectFromList(String headingMessage, String promptMessage, Map<String, String> options, boolean ignoreCase, String defaultValue) {
        String answer;
        HashSet<String> allowedAnswers = new HashSet<String>(options.keySet());
        if (defaultValue != null && !defaultValue.equals("")) {
            allowedAnswers.add("");
        }
        this.shellHelper.println(String.format("%s: ", headingMessage));
        do {
            for (Map.Entry<String, String> option : options.entrySet()) {
                String defaultMarker = null;
                if (defaultValue != null && option.getKey().equals(defaultValue)) {
                    defaultMarker = "*";
                }
                if (defaultMarker != null) {
                    this.shellHelper.printlnInfo(String.format("%s [%s] %s ", defaultMarker, option.getKey(), option.getValue()));
                    continue;
                }
                this.shellHelper.println(String.format("  [%s] %s", option.getKey(), option.getValue()));
            }
        } while (!this.containsString(allowedAnswers, answer = this.lineReader.readLine(String.format("%s: ", promptMessage)), ignoreCase) && "" != answer);
        if (StringUtils.hasText((String)answer) && allowedAnswers.contains("")) {
            return defaultValue;
        }
        return answer;
    }

    private boolean containsString(Set<String> l, String s, boolean ignoreCase) {
        if (!ignoreCase) {
            return l.contains(s);
        }
        Iterator<String> it = l.iterator();
        while (it.hasNext()) {
            if (!it.next().equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }
}

