/*
 * Decompiled with CFR 0.152.
 */
package net.griffiti.shell;

import net.griffiti.shell.Chalk;
import net.griffiti.shell.PromptColor;
import org.jline.terminal.Terminal;
import org.springframework.beans.factory.annotation.Value;

public class ShellHelper {
    @Value(value="${shell.out.info:CYAN}")
    private String infoColor;
    @Value(value="${shell.out.success:GREEN}")
    private String successColor;
    @Value(value="${shell.out.warning:YELLOW}")
    private String warningColor;
    @Value(value="${shell.out.error:RED}")
    private String errorColor;
    private Terminal terminal;

    public ShellHelper(Terminal terminal) {
        this.terminal = terminal;
    }

    public void println(String message) {
        this.println(message, null);
    }

    public void printlnSuccess(String message) {
        this.println(message, PromptColor.valueOf(this.successColor));
    }

    public void printlnInfo(String message) {
        this.println(message, PromptColor.valueOf(this.infoColor));
    }

    public void printlnWarning(String message) {
        this.println(message, PromptColor.valueOf(this.warningColor));
    }

    public void printlnError(String message) {
        this.println(message, PromptColor.valueOf(this.errorColor));
    }

    public void print(String message) {
        this.print(message, null);
    }

    public void printSuccess(String message) {
        this.println(message, PromptColor.valueOf(this.successColor));
    }

    public void printInfo(String message) {
        this.print(message, PromptColor.valueOf(this.infoColor));
    }

    public void printWarning(String message) {
        this.print(message, PromptColor.valueOf(this.warningColor));
    }

    public void printError(String message) {
        this.print(message, PromptColor.valueOf(this.errorColor));
    }

    public void print(String message, PromptColor color) {
        String toPrint = message;
        if (color != null) {
            toPrint = Chalk.color(message, color);
        }
        this.terminal.writer().print(toPrint);
        this.terminal.flush();
    }

    public void println(String message, PromptColor color) {
        String toPrint = message;
        if (color != null) {
            toPrint = Chalk.color(message, color);
        }
        this.terminal.writer().println(toPrint);
        this.terminal.flush();
    }

    public void deleteCurrentLine() {
        this.terminal.writer().println("\r\u001b[1M");
    }

    public void deleteLines(int numLines) {
        this.terminal.writer().println("\r" + String.format("\u001b[%d1M", numLines));
    }

    public void clearScreen() {
        this.terminal.writer().println("\u001b[H\u001b[2J");
    }
}

