/*
 * Decompiled with CFR 0.152.
 */
package net.griffiti.shell.progress;

import net.griffiti.shell.Chalk;
import org.jline.terminal.Terminal;
import org.springframework.beans.factory.annotation.Value;

public class ProgressBar {
    @Value(value="${shell.out.success:GREEN}")
    private String successColor;
    private String doneMarker = "=";
    private String remainsMarker = "-";
    private String leftDelimiter = "<";
    private String rightDelimiter = ">";
    Terminal terminal;
    private boolean started = false;

    public ProgressBar(Terminal terminal) {
        this.terminal = terminal;
    }

    public void display(int percentage) {
        this.display(percentage, null);
    }

    public void display(int percentage, String statusMessage) {
        if (!this.started) {
            this.started = true;
            this.terminal.writer().println();
        }
        int x = percentage / 5;
        int y = 20 - x;
        String message = statusMessage == null ? "" : statusMessage;
        String done = Chalk.color(new String(new char[x]).replace("\u0000", this.doneMarker), this.successColor);
        String remains = new String(new char[y]).replace("\u0000", this.remainsMarker);
        String progressBar = String.format("%s%s%s%s %d", this.leftDelimiter, done, remains, this.rightDelimiter, percentage);
        this.terminal.writer().println("\u001b[A\r\u001b[1M" + progressBar + "% " + message);
        this.terminal.flush();
    }

    public void reset() {
        this.started = false;
    }

    public String getDoneMarker() {
        return this.doneMarker;
    }

    public void setDoneMarker(String doneMarker) {
        this.doneMarker = doneMarker;
    }

    public String getRemainsMarker() {
        return this.remainsMarker;
    }

    public void setRemainsMarker(String remainsMarker) {
        this.remainsMarker = remainsMarker;
    }

    public String getLeftDelimiter() {
        return this.leftDelimiter;
    }

    public void setLeftDelimiter(String leftDelimiter) {
        this.leftDelimiter = leftDelimiter;
    }

    public String getRightDelimiter() {
        return this.rightDelimiter;
    }

    public void setRightDelimiter(String rightDelimiter) {
        this.rightDelimiter = rightDelimiter;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }
}

