/*
 * Decompiled with CFR 0.152.
 */
package net.griffiti.shell.progress;

import net.griffiti.shell.progress.SpinnerPosition;
import org.jline.terminal.Terminal;

public class ProgressCounter {
    private Terminal terminal;
    private String pattern = "%s: %d ";
    private char[] spinner = new char[]{'|', '/', '-', '\\'};
    private SpinnerPosition spinnerPosition = SpinnerPosition.LEFT;
    private boolean started = false;
    private int spinCounter = 0;

    public ProgressCounter(Terminal terminal) {
        this(terminal, null);
    }

    public ProgressCounter(Terminal terminal, String pattern) {
        this(terminal, pattern, null, null);
    }

    public ProgressCounter(Terminal terminal, String pattern, char[] spinner) {
        this(terminal, pattern, spinner, null);
    }

    public ProgressCounter(Terminal terminal, String pattern, char[] spinner, SpinnerPosition spinnerPosition) {
        this.terminal = terminal;
        if (pattern != null) {
            this.pattern = pattern;
        }
        if (spinner != null) {
            this.spinner = spinner;
        }
        if (spinnerPosition != null) {
            this.spinnerPosition = spinnerPosition;
        }
    }

    public void display(String message) {
        if (!this.started) {
            this.terminal.writer().println();
            this.started = true;
        }
        String progress = String.format(this.pattern, message);
        String displayOutput = this.getDisplayOutput(progress);
        this.terminal.writer().println("\u001b[A\r\u001b[1M" + displayOutput);
        this.terminal.flush();
    }

    public void display(int count, String message) {
        if (!this.started) {
            this.terminal.writer().println();
            this.started = true;
        }
        String progress = String.format(this.pattern, message, count);
        String displayOutput = this.getDisplayOutput(progress);
        this.terminal.writer().println("\u001b[A\r\u001b[1M" + displayOutput);
        this.terminal.flush();
    }

    public void display() {
        if (!this.started) {
            this.terminal.writer().println();
            this.started = true;
        }
        this.terminal.writer().println("\u001b[A\r\u001b[1M" + this.getSpinnerChar());
        this.terminal.flush();
    }

    public void reset() {
        this.spinCounter = 0;
        this.started = false;
        this.terminal.writer().println("\u001b[A\r\u001b[1M");
        this.terminal.flush();
    }

    private String getDisplayOutput(String progress) {
        StringBuilder output = new StringBuilder();
        if (this.spinnerPosition == SpinnerPosition.LEFT) {
            output.append(this.getSpinnerChar());
            output.append(" ");
        }
        output.append(progress);
        if (this.spinnerPosition == SpinnerPosition.RIGHT) {
            output.append(" ");
            output.append(this.getSpinnerChar());
        }
        return output.toString();
    }

    private char getSpinnerChar() {
        char spinChar = this.spinner[this.spinCounter];
        ++this.spinCounter;
        if (this.spinCounter == this.spinner.length) {
            this.spinCounter = 0;
        }
        return spinChar;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public char[] getSpinner() {
        return this.spinner;
    }

    public void setSpinner(char[] spinner) {
        this.spinner = spinner;
    }

    public SpinnerPosition getSpinnerPosition() {
        return this.spinnerPosition;
    }

    public void setSpinnerPosition(SpinnerPosition spinnerPosition) {
        this.spinnerPosition = spinnerPosition;
    }

    public boolean getStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public int getSpinCounter() {
        return this.spinCounter;
    }

    public void setSpinCounter(int spinCounter) {
        this.spinCounter = spinCounter;
    }
}

