/*
 * Decompiled with CFR 0.152.
 */
package net.griffiti.shell.table.ascii;

import java.util.Arrays;
import java.util.List;
import net.griffiti.shell.InputReader;
import net.griffiti.shell.table.TableDataSource;
import net.griffiti.shell.table.TableRenderer;
import net.griffiti.shell.table.ascii.BasicTableRenderer;

public class PageableTableRenderer
implements TableRenderer {
    public static final int DEFAULT_PAGE_SIZE = 15;
    private BasicTableRenderer basicTableRenderer;
    private int pageSize;
    private InputReader inputReader;

    public PageableTableRenderer(InputReader inputReader) {
        this(new BasicTableRenderer(), inputReader, 15);
    }

    public PageableTableRenderer(InputReader inputReader, int tableSize, int pageSize) {
        this(new BasicTableRenderer(tableSize), inputReader, pageSize);
    }

    public PageableTableRenderer(BasicTableRenderer basicTableRenderer, InputReader inputReader, int pageSize) {
        this.basicTableRenderer = basicTableRenderer;
        this.pageSize = pageSize;
        this.inputReader = inputReader;
    }

    @Override
    public String render(List<String> headers, TableDataSource tableDataSource) {
        String displayResult;
        PageableTableDataSource pageableTableDataSource = new PageableTableDataSource(tableDataSource);
        int total = tableDataSource.size();
        int i = 0;
        block10: do {
            pageableTableDataSource.setIndex(i);
            String errorsTable = this.basicTableRenderer.render(headers, pageableTableDataSource);
            String summaryLine = "Displaying results " + i + " to " + (i + pageableTableDataSource.size()) + " of " + total + "\n";
            displayResult = errorsTable + "\n" + summaryLine;
            if (total - i <= this.pageSize) break;
            String commandLine = "Enter n or press ENTER for the next page, p for the previous page, or q to quit";
            displayResult = displayResult + commandLine;
            String answer = this.inputReader.promptWithOptions(displayResult, "n", Arrays.asList("n", "p", "q"));
            switch (answer.toLowerCase()) {
                case "q": {
                    return "";
                }
                case "n": {
                    i += this.pageSize;
                    break;
                }
                case "p": {
                    if (i == 0) continue block10;
                    i -= this.pageSize;
                    break;
                }
                default: {
                    return "";
                }
            }
        } while (i < total);
        return displayResult;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    private class PageableTableDataSource
    implements TableDataSource {
        private int index;
        private TableDataSource tableDataSource;

        PageableTableDataSource(TableDataSource tableDataSource) {
            this.tableDataSource = tableDataSource;
        }

        @Override
        public int size() {
            int total = this.tableDataSource.size();
            if (this.index + PageableTableRenderer.this.pageSize < total) {
                return PageableTableRenderer.this.pageSize;
            }
            return total - this.index;
        }

        @Override
        public List<String> getRowElements(int rowNumber) {
            return this.tableDataSource.getRowElements(this.index + rowNumber);
        }

        void setIndex(int index) {
            this.index = index;
        }
    }
}

