/*
 * Decompiled with CFR 0.152.
 */
package net.griffiti.shell.table.spring;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.shell.table.ArrayTableModel;
import org.springframework.shell.table.TableModel;

public class BeanTableModelBuilder {
    private ObjectMapper objectMapper;
    private Object bean;
    private LinkedHashMap<String, Object> labels;
    private String[] header;

    public BeanTableModelBuilder(Object bean, ObjectMapper objectMapper) {
        this.bean = bean;
        this.objectMapper = objectMapper;
    }

    public BeanTableModelBuilder withLabels(LinkedHashMap<String, Object> labels) {
        this.labels = labels;
        return this;
    }

    public BeanTableModelBuilder withHeader(String[] header) {
        this.header = header;
        return this;
    }

    public TableModel build() {
        Map map = (Map)this.objectMapper.convertValue(this.bean, (TypeReference)new TypeReference<Map<String, String>>(){});
        int targetSize = this.header == null ? map.size() : map.size() + 1;
        Object[][] entityProperties = new Object[targetSize][2];
        int i = 0;
        if (this.header != null) {
            entityProperties[0][0] = this.header[0];
            entityProperties[0][1] = this.header[1];
            i = 1;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object label = this.labels != null ? this.labels.get(entry.getKey()) : entry.getKey();
            entityProperties[i][0] = label + ":";
            entityProperties[i][1] = entry.getValue();
            ++i;
        }
        return new ArrayTableModel(entityProperties);
    }
}

