package net.guerlab.commons.abstractslayout;

/**
 * 应用基础异常
 * 
 * @author guer
 *
 */
public class ApplicationError extends RuntimeException {

    private static final long serialVersionUID = 1L;

    /**
     * 默认错误信息
     */
    public static final String DEFAULT_MSG = "服务器忙，请稍后再试";

    /**
     * 错误码
     */
    private final int errorCode;

    /**
     * 构造一个应用基础异常
     */
    public ApplicationError() {
        this(0);
    }

    /**
     * 构造一个应用基础异常
     * 
     * @param errorCode
     *            错误码
     */
    public ApplicationError(
            int errorCode) {
        super(DEFAULT_MSG);
        this.errorCode = errorCode;
    }

    /**
     * 构造一个应用基础异常
     * 
     * @param message
     *            异常信息
     * @param cause
     *            导致的原因
     * @param enableSuppression
     *            启用抑制
     * @param writableStackTrace
     *            写入异常栈
     */
    public ApplicationError(
            String message,
            Throwable cause,
            boolean enableSuppression,
            boolean writableStackTrace) {
        this(message, cause, enableSuppression, writableStackTrace, 0);
    }

    /**
     * 构造一个应用基础异常
     * 
     * @param message
     *            异常信息
     * @param cause
     *            导致的原因
     * @param enableSuppression
     *            启用抑制
     * @param writableStackTrace
     *            写入异常栈
     * @param errorCode
     *            错误码
     */
    public ApplicationError(
            String message,
            Throwable cause,
            boolean enableSuppression,
            boolean writableStackTrace,
            int errorCode) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.errorCode = errorCode;
    }

    /**
     * 构造一个应用基础异常
     * 
     * @param message
     *            异常信息
     * @param cause
     *            导致的原因
     */
    public ApplicationError(
            String message,
            Throwable cause) {
        this(message, cause, 0);
    }

    /**
     * 构造一个应用基础异常
     * 
     * @param message
     *            异常信息
     * @param cause
     *            导致的原因
     * @param errorCode
     *            错误码
     */
    public ApplicationError(
            String message,
            Throwable cause,
            int errorCode) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    /**
     * 构造一个应用基础异常
     * 
     * @param message
     *            异常信息
     */
    public ApplicationError(
            String message) {
        this(message, 0);
    }

    /**
     * 构造一个应用基础异常
     * 
     * @param message
     *            异常信息
     * @param errorCode
     *            错误码
     */
    public ApplicationError(
            String message,
            int errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    /**
     * 构造一个应用基础异常
     * 
     * @param cause
     *            导致的原因
     */
    public ApplicationError(
            Throwable cause) {
        this(cause, 0);
    }

    /**
     * 构造一个应用基础异常
     * 
     * @param cause
     *            导致的原因
     * @param errorCode
     *            错误码
     */
    public ApplicationError(
            Throwable cause,
            int errorCode) {
        super(cause);
        this.errorCode = errorCode;
    }

    /**
     * 返回错误码
     * 
     * @return 错误码
     */
    public int getErrorCode() {
        return errorCode;
    }
}