package net.guerlab.commons.abstractslayout;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 简易实现
 *
 * @author guer
 *
 */
class Impls {

    private static final Logger LOGGER = LoggerFactory.getLogger(Impls.class);

    private Impls() {
    }

    /**
     * 删除
     *
     * @param dao
     *            dao
     * @param entity
     *            实体
     * @param exceptionCallback
     *            异常回调
     */
    static <E> void delete(
            final AbstractDAO<E> dao,
            final E entity,
            Consumer<Exception> exceptionCallback) {
        try {
            dao.delete(entity);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            if (exceptionCallback != null) {
                exceptionCallback.accept(e);
            }
            throw e;
        }
    }

    /**
     * 批量保存
     *
     * @param dao
     *            dao
     * @param entityList
     *            实体列表
     * @param exceptionCallback
     *            异常回调
     * @param predicate
     *            过滤器方法
     */
    static <E> void batchSave(
            final AbstractDAO<E> dao,
            final List<E> entityList,
            Consumer<Exception> exceptionCallback,
            Predicate<E> predicate) {
        if (entityList == null || entityList.isEmpty()) {
            LOGGER.debug("entityList is empty");
            return;
        }

        List<E> saveList = entityList.stream().filter(predicate).collect(Collectors.toList());

        if (saveList == null || saveList.isEmpty()) {
            LOGGER.debug("filted saveList is empty");
            return;
        }

        try {
            dao.batchSave(saveList);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            if (exceptionCallback != null) {
                exceptionCallback.accept(e);
            }
            throw e;
        }
    }
}
