package net.guerlab.commons.time.jackson.deserializer;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import net.guerlab.commons.time.TimeHelper;

/**
 * 日期反序列化处理
 *
 * @author guer
 *
 */
public class LocalDateDeserializer extends JsonDeserializer<LocalDate> {

    @Override
    public LocalDate deserialize(
            JsonParser jp,
            DeserializationContext ctxt) throws IOException {
        LocalDateTime time = TimeHelper.parseLocalDateTime(jp.getValueAsString());
        return time == null ? null : time.toLocalDate();
    }
}