package net.guerlab.commons.time.jackson.deserializer;

import java.io.IOException;
import java.time.LocalDateTime;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import net.guerlab.commons.time.TimeHelper;

/**
 * 日期时间反序列化处理
 *
 * @author guer
 *
 */
public class LocalDateTimeDeserializer extends JsonDeserializer<LocalDateTime> {

    @Override
    public LocalDateTime deserialize(
            JsonParser jp,
            DeserializationContext ctxt) throws IOException {
        return TimeHelper.parseLocalDateTime(jp.getValueAsString());
    }
}