package net.guerlab.commons.time.jackson.deserializer;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.LocalTime;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import net.guerlab.commons.time.TimeHelper;

/**
 * 时间反序列化处理
 *
 * @author guer
 *
 */
public class LocalTimeDeserializer extends JsonDeserializer<LocalTime> {

    @Override
    public LocalTime deserialize(
            JsonParser jp,
            DeserializationContext ctxt) throws IOException {
        LocalDateTime time = TimeHelper.parseLocalDateTime(jp.getValueAsString());
        return time == null ? null : time.toLocalTime();
    }
}