package net.guerlab.commons.time.jackson.deserializer;

import java.io.IOException;
import java.time.Month;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

/**
 * 月份反序列化处理
 *
 * @author guer
 *
 */
public class MonthDeserializer extends JsonDeserializer<Month> {

    @Override
    public Month deserialize(
            JsonParser jp,
            DeserializationContext ctxt) throws IOException {
        return Month.of(jp.getValueAsInt());
    }
}