package net.guerlab.commons.time.jackson.deserializer;

import java.io.IOException;
import java.time.Year;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

/**
 * 年份反序列化处理
 *
 * @author guer
 *
 */
public class YearDeserializer extends JsonDeserializer<Year> {

    @Override
    public Year deserialize(
            JsonParser jp,
            DeserializationContext ctxt) throws IOException {
        return Year.of(jp.getValueAsInt());
    }
}