package net.guerlab.commons.time.jackson.serializer;

import java.io.IOException;
import java.time.Month;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

/**
 * 月份序列化处理
 *
 * @author guer
 *
 */
public class MonthSerializer extends JsonSerializer<Month> {

    @Override
    public void serialize(
            Month value,
            JsonGenerator gen,
            SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }

        gen.writeNumber(value.getValue());

    }
}