package net.guerlab.commons.time.jackson.serializer;

import java.io.IOException;
import java.time.Year;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

/**
 * 年份序列化处理
 *
 * @author guer
 *
 */
public class YearSerializer extends JsonSerializer<Year> {

    @Override
    public void serialize(
            Year value,
            JsonGenerator gen,
            SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }

        gen.writeNumber(value.getValue());

    }
}