/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.abstractslayout;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.guerlab.commons.abstractslayout.AbstractDAO;
import net.guerlab.commons.searchparams.AbstractSearchParams;
import net.guerlab.commons.searchparams.SearchParamsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractReadOnlyDQI<E, D extends AbstractDAO<E>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReadOnlyDQI.class);
    @Autowired
    protected D dao;

    public E findOne(AbstractSearchParams searchParams) {
        return this.findOne(searchParams, null);
    }

    public E findOne(AbstractSearchParams searchParams, Consumer<Exception> exceptionCallback) {
        Map<String, Object> params = SearchParamsHelper.toMap(searchParams);
        try {
            return (E)this.dao.findOne(params);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (exceptionCallback != null) {
                exceptionCallback.accept(e);
            }
            return null;
        }
    }

    public List<E> findList(AbstractSearchParams searchParams) {
        return this.findList(searchParams, null);
    }

    public List<E> findList(AbstractSearchParams searchParams, Consumer<Exception> exceptionCallback) {
        Map<String, Object> params = SearchParamsHelper.toMap(searchParams);
        try {
            return this.dao.findList(params);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (exceptionCallback != null) {
                exceptionCallback.accept(e);
            }
            return Collections.emptyList();
        }
    }

    public int findCount(AbstractSearchParams searchParams) {
        return this.findCount(searchParams, null);
    }

    public int findCount(AbstractSearchParams searchParams, Consumer<Exception> exceptionCallback) {
        Map<String, Object> params = SearchParamsHelper.toMap(searchParams);
        try {
            return this.dao.findCount(params);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (exceptionCallback != null) {
                exceptionCallback.accept(e);
            }
            return 0;
        }
    }
}

