/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.abstractslayout;

import java.util.function.Consumer;
import net.guerlab.commons.abstractslayout.AbstractDAO;
import net.guerlab.commons.abstractslayout.AbstractReadOnlyDQI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaveDQI<E, D extends AbstractDAO<E>>
extends AbstractReadOnlyDQI<E, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSaveDQI.class);

    public void save(E entity) {
        this.save(entity, null);
    }

    public void save(E entity, Consumer<Exception> exceptionCallback) {
        this.saveCheck(entity);
        try {
            this.dao.save(entity);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (exceptionCallback != null) {
                exceptionCallback.accept(e);
            }
            throw e;
        }
    }

    public abstract void saveCheck(E var1);
}

