/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.abstractslayout;

import java.util.function.Consumer;
import net.guerlab.commons.abstractslayout.AbstractDAO;
import net.guerlab.commons.abstractslayout.AbstractSaveDQI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUpdateDQI<E, D extends AbstractDAO<E>>
extends AbstractSaveDQI<E, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractUpdateDQI.class);

    public void update(E entity) {
        this.update(entity, null);
    }

    public void update(E entity, Consumer<Exception> exceptionCallback) {
        this.updateCheck(entity);
        try {
            this.dao.update(entity);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (exceptionCallback != null) {
                exceptionCallback.accept(e);
            }
            throw e;
        }
    }

    public abstract void updateCheck(E var1);
}

