/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.abstractslayout;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.guerlab.commons.abstractslayout.AbstractDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Impls {
    private static final Logger LOGGER = LoggerFactory.getLogger(Impls.class);

    private Impls() {
    }

    static <E> void delete(AbstractDAO<E> dao, E entity, Consumer<Exception> exceptionCallback) {
        try {
            dao.delete(entity);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (exceptionCallback != null) {
                exceptionCallback.accept(e);
            }
            throw e;
        }
    }

    static <E> void batchSave(AbstractDAO<E> dao, List<E> entityList, Consumer<Exception> exceptionCallback, Predicate<E> predicate) {
        if (entityList == null || entityList.isEmpty()) {
            LOGGER.debug("entityList is empty");
            return;
        }
        List saveList = entityList.stream().filter(predicate).collect(Collectors.toList());
        if (saveList == null || saveList.isEmpty()) {
            LOGGER.debug("filted saveList is empty");
            return;
        }
        try {
            dao.batchSave(saveList);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (exceptionCallback != null) {
                exceptionCallback.accept(e);
            }
            throw e;
        }
    }
}

