/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionConversionHandle;
import net.guerlab.commons.collection.CollectionFilterHandle;

public final class CollectionHelper {
    private CollectionHelper() {
        throw new SecurityException();
    }

    public static final <T> List<T> toList(T[] arrays) {
        return arrays == null || arrays.length == 0 ? Collections.emptyList() : Arrays.stream(arrays).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static final <T> List<T> toList(Collection<T> collection) {
        return collection == null || collection.isEmpty() ? Collections.emptyList() : collection.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static final <T> Set<T> toSet(T[] arrays) {
        return arrays == null || arrays.length == 0 ? Collections.emptySet() : Arrays.stream(arrays).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static final <T> Set<T> toSet(Collection<T> collection) {
        return collection == null || collection.isEmpty() ? Collections.emptySet() : collection.stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static final <E> void copy(Collection<E> in, Collection<E> out) {
        CollectionHelper.copy(in, out, false);
    }

    public static final <E> void copy(Collection<E> in, Collection<E> out, boolean checkNull) {
        if (out == null) {
            return;
        }
        out.clear();
        if (in == null || in.isEmpty()) {
            return;
        }
        in.stream().filter(e -> !checkNull || e != null).forEach(out::add);
    }

    public static final <E> void copy(E[] in, Collection<E> out) {
        CollectionHelper.copy(in, out, false);
    }

    public static final <E> void copy(E[] in, Collection<E> out, boolean checkNull) {
        if (out == null) {
            return;
        }
        out.clear();
        if (in == null || in.length == 0) {
            return;
        }
        Arrays.stream(in).filter(e -> !checkNull || e != null).forEach(out::add);
    }

    public static final <E> void addAll(Collection<E> in, Collection<E> out) {
        CollectionHelper.addAll(in, out, false);
    }

    public static final <E> void addAll(Collection<E> in, Collection<E> out, boolean checkNull) {
        if (out == null || in == null || in.isEmpty()) {
            return;
        }
        in.stream().filter(e -> !checkNull || e != null).forEach(out::add);
    }

    public static final <E> void addAll(E[] in, Collection<E> out) {
        CollectionHelper.addAll(in, out, false);
    }

    public static final <E> void addAll(E[] in, Collection<E> out, boolean checkNull) {
        if (out == null || in == null || in.length == 0) {
            return;
        }
        Arrays.stream(in).filter(e -> !checkNull || e != null).forEach(out::add);
    }

    public static final <I, O> void conversion(I[] inList, Collection<O> outCollection, CollectionConversionHandle<I, O> conversion) {
        if (inList == null || outCollection == null || conversion == null) {
            return;
        }
        outCollection.clear();
        if (inList.length == 0) {
            return;
        }
        Arrays.stream(inList).forEach(e -> outCollection.add(conversion.conversion(e)));
    }

    public static final <I, O> void conversion(Collection<I> inCollection, Collection<O> outCollection, CollectionConversionHandle<I, O> conversion) {
        if (inCollection == null || outCollection == null || conversion == null) {
            return;
        }
        outCollection.clear();
        if (inCollection.isEmpty()) {
            return;
        }
        inCollection.stream().forEach(e -> outCollection.add(conversion.conversion(e)));
    }

    public static final <E> boolean exists(Collection<E> in, CollectionFilterHandle<E> handle) {
        if (in == null || in.isEmpty() || handle == null) {
            return false;
        }
        return in.stream().anyMatch(handle::filter);
    }

    public static final <E> Collection<E> filter(Collection<E> in, CollectionFilterHandle<E> handle) {
        if (in == null || in.isEmpty() || handle == null) {
            return in;
        }
        Collection<E> newCollection = in;
        Iterator<E> iterable = newCollection.iterator();
        while (iterable.hasNext()) {
            E e = iterable.next();
            if (handle.filter(e)) continue;
            iterable.remove();
        }
        return newCollection;
    }
}

