/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.dbpaging;

import java.util.Map;
import net.guerlab.commons.dbpaging.DBPaging;
import net.guerlab.commons.number.NumberHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBPagingHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBPagingHelper.class);
    public static final String PAGE_BEGIN = "page_begin";
    public static final String PAGE_END = "page_end";
    public static final String PAGE_LIMIT = "page_limit";
    public static final String PAGE_PAGE = "page_page";
    private static int globalPageSize = 10;

    private DBPagingHelper() {
        throw new SecurityException();
    }

    public static DBPaging pageSet(long pageId, long pageSize) {
        long nowPageId = Math.max(pageId, 1L);
        long nowPageSize = Math.max(pageSize, 1L);
        long begin = (nowPageId - 1L) * nowPageSize;
        long end = begin + nowPageSize - 1L;
        return new DBPaging(begin, end, nowPageId, nowPageSize);
    }

    public static void pageSet(long pageId, long pageSize, Map<String, Object> params) {
        if (params == null) {
            return;
        }
        DBPaging dbPaging = DBPagingHelper.pageSet(pageId, pageSize);
        params.put(PAGE_BEGIN, dbPaging.getBegin());
        params.put(PAGE_END, dbPaging.getEnd());
        params.put(PAGE_LIMIT, dbPaging.getPageSize());
        params.put(PAGE_PAGE, dbPaging.getPage());
    }

    public static void setGlobalPageSize(int globalPageSize) {
        if (!NumberHelper.greaterZero(globalPageSize)) {
            throw new IllegalArgumentException("globalPageSize must be greater zero");
        }
        DBPagingHelper.globalPageSize = globalPageSize;
        LOGGER.trace("set globalPageSize={}", (Object)globalPageSize);
    }

    public static int getGlobalPageSize() {
        return globalPageSize;
    }

    static {
        String sizeString = System.getProperties().getProperty("guerlab.dbpaging.size");
        Integer size = null;
        try {
            size = Integer.parseInt(sizeString);
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
        if (NumberHelper.greaterZero(size)) {
            globalPageSize = size;
            LOGGER.trace("init globalPageSize={}", (Object)size);
        }
    }
}

