/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.field;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.guerlab.commons.abstractslayout.ApplicationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldHelper.class);
    private static final Class<?>[] BASE_NUMBER_CLASS_LIST = new Class[]{Byte.TYPE, Short.TYPE, Long.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final Map<Class<?>, List<Field>> CACHE = new ConcurrentHashMap();
    private static final BaseFilter BASE_FILTER = new BaseFilter();
    private static Class<?> FAST_JSON_CLASS = null;

    private FieldHelper() {
        throw new SecurityException();
    }

    public static void valueCopy(Object in, Object out) {
        if (in == null || out == null) {
            return;
        }
        List<Field> inFields = FieldHelper.getFiledsWithFilter(in.getClass(), BASE_FILTER);
        List<Field> outFields = FieldHelper.getFiledsWithFilter(out.getClass(), BASE_FILTER);
        if (inFields.isEmpty() || outFields.isEmpty()) {
            return;
        }
        HashMap<String, Field> outFieldMap = new HashMap<String, Field>(outFields.size());
        for (Field field : outFields) {
            outFieldMap.put(field.getName(), field);
        }
        inFields.stream().forEach(e -> FieldHelper.valueCopyOnce(e, outFieldMap, in, out));
    }

    private static void valueCopyOnce(Field inField, Map<String, Field> outFieldMap, Object in, Object out) {
        Class<?> outType;
        if (inField == null) {
            return;
        }
        String name = inField.getName();
        Class<?> inType = inField.getType();
        Field outField = outFieldMap.get(name);
        Class<?> clazz = outType = outField == null ? null : outField.getType();
        if (outField == null || !inType.equals(outType)) {
            return;
        }
        try {
            Object object = FieldHelper.read(in, name);
            FieldHelper.write(out, name, object);
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
        }
    }

    public static Object get(Object object, String name) {
        try {
            return FieldHelper.read(object, name);
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object read(Object object, String name) {
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, object.getClass());
            Method method = propertyDescriptor.getReadMethod();
            return method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new ApplicationError(e.getMessage(), e);
        }
    }

    public static Object put(Object object, String name, Object value) {
        try {
            return FieldHelper.write(object, name, value);
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object write(Object object, String name, Object value) {
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, object.getClass());
            Method method = propertyDescriptor.getWriteMethod();
            return method.invoke(object, value);
        }
        catch (Exception e) {
            throw new ApplicationError(e.getMessage(), e);
        }
    }

    public static boolean isJson(Class<?> fieldType) {
        return FAST_JSON_CLASS != null && FAST_JSON_CLASS.isAssignableFrom(fieldType);
    }

    public static boolean isNumberClass(Class<?> fieldType) {
        if (fieldType == null) {
            return false;
        }
        if (Number.class.isAssignableFrom(fieldType)) {
            return true;
        }
        for (Class<?> element : BASE_NUMBER_CLASS_LIST) {
            if (fieldType != element) continue;
            return true;
        }
        return false;
    }

    public static List<Field> getFileds(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        List<Field> allFields = CACHE.get(clazz);
        if (allFields != null) {
            return allFields;
        }
        allFields = new ArrayList<Field>();
        LinkedList classes = new LinkedList();
        Class<?> paramsClass = clazz;
        long classNum = 0L;
        while (true) {
            Class<?> superClass = paramsClass.getSuperclass();
            classes.add(paramsClass);
            ++classNum;
            if (Object.class.equals(superClass)) break;
            paramsClass = paramsClass.getSuperclass();
        }
        for (long i = 0L; i < classNum; ++i) {
            for (Field field : ((Class)classes.pollFirst()).getDeclaredFields()) {
                allFields.add(field);
            }
        }
        CACHE.put(clazz, allFields);
        return allFields;
    }

    @SafeVarargs
    public static List<Field> getFiledsWithFilter(Class<?> clazz, Predicate<Field> ... filters) {
        List<Field> list = FieldHelper.getFileds(clazz);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        Stream<Object> stream = list.stream();
        for (Predicate<Field> filter : filters) {
            if (filter == null) continue;
            stream = stream.filter(filter);
        }
        return stream.collect(Collectors.toList());
    }

    public static List<Field> getFiledsWithFilter(Class<?> clazz) {
        return FieldHelper.getFiledsWithFilter(clazz, BASE_FILTER, new CollectionAndArrayFilter());
    }

    static {
        try {
            FAST_JSON_CLASS = FieldHelper.class.getClassLoader().loadClass("com.alibaba.fastjson.JSON");
        }
        catch (Exception e) {
            LOGGER.debug("cann't find fastjson jar");
        }
    }

    private static class CollectionAndArrayFilter
    implements Predicate<Field> {
        private CollectionAndArrayFilter() {
        }

        @Override
        public boolean test(Field field) {
            return field != null && !Collection.class.isAssignableFrom(field.getType()) && !field.getType().isArray();
        }
    }

    private static class BaseFilter
    implements Predicate<Field> {
        private BaseFilter() {
        }

        @Override
        public boolean test(Field field) {
            if (field == null) {
                return false;
            }
            Class<?> fieldType = field.getType();
            int mod = field.getModifiers();
            if (Map.class.isAssignableFrom(fieldType)) {
                return FieldHelper.isJson(fieldType);
            }
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) {
                return false;
            }
            boolean isSys = fieldType.getName().startsWith("java") || fieldType.isPrimitive();
            boolean isEnum = fieldType.isEnum();
            return isSys || isEnum;
        }
    }
}

