/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.commons.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public final class NumberHelper {
    private NumberHelper() {
        throw new SecurityException();
    }

    public static boolean isEquals(Byte a, Byte b) {
        return a != null && b != null && a.compareTo(b) == 0;
    }

    public static boolean isEquals(Character a, Character b) {
        return a != null && b != null && a.compareTo(b) == 0;
    }

    public static boolean isEquals(Short a, Short b) {
        return a != null && b != null && a.compareTo(b) == 0;
    }

    public static boolean isEquals(Integer a, Integer b) {
        return a != null && b != null && a.compareTo(b) == 0;
    }

    public static boolean isEquals(Long a, Long b) {
        return a != null && b != null && a.compareTo(b) == 0;
    }

    public static boolean isEquals(Float a, Float b) {
        return a != null && b != null && a.compareTo(b) == 0;
    }

    public static boolean isEquals(Double a, Double b) {
        return a != null && b != null && a.compareTo(b) == 0;
    }

    public static boolean isEquals(BigInteger a, BigInteger b) {
        return a != null && b != null && a.compareTo(b) == 0;
    }

    public static boolean isEquals(BigDecimal a, BigDecimal b) {
        return a != null && b != null && a.compareTo(b) == 0;
    }

    public static boolean ltZero(Number number) {
        return !NumberHelper.greaterZero(number);
    }

    public static boolean gtZero(Number number) {
        return NumberHelper.greaterZero(number);
    }

    public static boolean greaterZero(Number number) {
        return number != null && number.doubleValue() > 0.0;
    }

    public static boolean anyGreaterZero(Number ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return false;
        }
        return Arrays.stream(numbers).anyMatch(NumberHelper::greaterZero);
    }

    public static boolean allGreaterZero(Number ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return false;
        }
        return Arrays.stream(numbers).allMatch(NumberHelper::greaterZero);
    }

    public static boolean greaterOrEqualZero(Number number) {
        return number != null && number.doubleValue() >= 0.0;
    }

    public static boolean anyGreaterOrEqualZero(Number ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return false;
        }
        return Arrays.stream(numbers).anyMatch(NumberHelper::greaterOrEqualZero);
    }

    public static boolean allGreaterOrEqualZero(Number ... numbers) {
        if (numbers == null || numbers.length == 0) {
            return false;
        }
        return Arrays.stream(numbers).allMatch(NumberHelper::greaterOrEqualZero);
    }
}

